/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.particle.lavawithphysics;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.codec.StreamCodec;
import voltaic.registers.VoltaicParticles;

public class ParticleOptionLavaWithPhysics
extends ParticleType<ParticleOptionLavaWithPhysics>
implements ParticleOptions {
    public float scale;
    public double bounceFactor;
    public int lifetime;
    public static final Codec<ParticleOptionLavaWithPhysics> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").forGetter(instance0 -> Float.valueOf(instance0.scale)), (App)Codec.INT.fieldOf("lifetime").forGetter(instance0 -> instance0.lifetime), (App)Codec.DOUBLE.fieldOf("bouncefactor").forGetter(instance0 -> instance0.bounceFactor)).apply((Applicative)instance, (scale, lifetime, bounceFactor) -> new ParticleOptionLavaWithPhysics().setParameters(scale.floatValue(), (int)lifetime, (double)bounceFactor)));
    public static final StreamCodec<FriendlyByteBuf, ParticleOptionLavaWithPhysics> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ParticleOptionLavaWithPhysics>(){

        @Override
        public void encode(FriendlyByteBuf buffer, ParticleOptionLavaWithPhysics value) {
            StreamCodec.FLOAT.encode((ByteBuf)buffer, Float.valueOf(value.scale));
            StreamCodec.INT.encode((ByteBuf)buffer, value.lifetime);
            StreamCodec.DOUBLE.encode((ByteBuf)buffer, value.bounceFactor);
        }

        @Override
        public ParticleOptionLavaWithPhysics decode(FriendlyByteBuf buffer) {
            return new ParticleOptionLavaWithPhysics().setParameters(buffer.readFloat(), buffer.readInt(), buffer.readDouble());
        }
    };
    public static final ParticleOptions.Deserializer<ParticleOptionLavaWithPhysics> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionLavaWithPhysics>(){

        public ParticleOptionLavaWithPhysics fromCommand(ParticleType<ParticleOptionLavaWithPhysics> pParticleType, StringReader reader) throws CommandSyntaxException {
            ParticleOptionLavaWithPhysics particle = new ParticleOptionLavaWithPhysics();
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            double bounceFactor = reader.readDouble();
            return particle.setParameters(scale, lifetime, bounceFactor);
        }

        public ParticleOptionLavaWithPhysics fromNetwork(ParticleType<ParticleOptionLavaWithPhysics> pParticleType, FriendlyByteBuf pBuffer) {
            return STREAM_CODEC.decode(pBuffer);
        }
    };

    public ParticleOptionLavaWithPhysics() {
        super(false, DESERIALIZER);
    }

    public ParticleOptionLavaWithPhysics setParameters(float scale, int lifetime, double bounceFactor) {
        this.scale = scale;
        this.lifetime = lifetime;
        this.bounceFactor = bounceFactor;
        return this;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)VoltaicParticles.PARTICLE_LAVAWITHPHYSICS.get();
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        STREAM_CODEC.encode(pBuffer, this);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()).toString() + ", scale: " + this.scale + ", bounceFactor: " + this.bounceFactor + ", lifetime: " + this.lifetime;
    }

    public Codec<ParticleOptionLavaWithPhysics> m_7652_() {
        return CODEC;
    }
}

