/*
 * Decompiled with CFR 0.152.
 */
package voltaic.common.network.utils;

import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class GasUtilities {
    public static boolean isGasReciever(BlockEntity acceptor, Direction dir) {
        return acceptor != null && acceptor.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, dir).isPresent();
    }

    public static int recieveGas(BlockEntity reciever, Direction dir, GasStack gas, GasAction action) {
        if (gas.isEmpty() || gas.getAmount() <= 0) {
            return 0;
        }
        GasStack copy = gas.copy();
        IGasHandler handler = (IGasHandler)reciever.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, dir).orElse((Object)CapabilityUtils.EMPTY_GAS);
        if (handler == CapabilityUtils.EMPTY_GAS) {
            return 0;
        }
        int taken = 0;
        int recieved = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            if (!handler.isGasValid(i, copy)) continue;
            recieved = handler.fill(copy, action);
            copy.shrink(recieved);
            taken += recieved;
        }
        return taken;
    }

    public static void outputToPipe(GenericTile tile, GasTank[] tanks, Direction ... outputDirections) {
        Direction facing = tile.getFacing();
        for (Direction relative : outputDirections) {
            IGasHandler handler;
            Direction direction = BlockEntityUtils.getRelativeSide(facing, relative);
            BlockEntity faceTile = tile.m_58904_().m_7702_(tile.m_58899_().m_121945_(direction));
            if (faceTile == null || (handler = (IGasHandler)faceTile.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, direction.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_GAS)) == CapabilityUtils.EMPTY_GAS) continue;
            for (GasTank gasTank : tanks) {
                if (gasTank.isEmpty()) {
                    // empty if block
                }
                for (int i = 0; i < handler.getTanks(); ++i) {
                    GasStack tankGas = gasTank.getGas().copy();
                    int amtAccepted = handler.fill(tankGas, GasAction.EXECUTE);
                    GasStack taken = new GasStack(tankGas.getGas(), amtAccepted, tankGas.getTemperature(), tankGas.getPressure());
                    gasTank.drain(taken, GasAction.EXECUTE);
                }
            }
        }
    }

    public static void drainItem(GenericTile tile, GasTank[] tanks) {
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        int cylinderIndex = inv.getInputGasStartIndex();
        int size = inv.getInputGasContents().size();
        if (tanks.length < size) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IGasHandlerItem handler;
            int index = cylinderIndex + i;
            GasTank tank = tanks[i];
            ItemStack stack = inv.m_8020_(index);
            int room = tank.getRoom();
            if (stack.m_41619_() || room <= 0 || (handler = (IGasHandlerItem)stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) == CapabilityUtils.EMPTY_GAS_ITEM) continue;
            for (int j = 0; j < handler.getTanks() && room > 0; ++j) {
                GasStack taken = handler.drain(room, GasAction.SIMULATE);
                if (taken.isEmpty() || !tank.isGasValid(taken)) continue;
                int takenAmt = tank.fill(taken, GasAction.EXECUTE);
                handler.drain(takenAmt, GasAction.EXECUTE);
                room = tank.getRoom();
            }
            inv.m_6836_(index, handler.getContainer());
        }
    }

    public static void fillItem(GenericTile tile, GasTank[] tanks) {
        ComponentInventory inv = (ComponentInventory)tile.getComponent(IComponentType.Inventory);
        int cylinderIndex = inv.getOutputGasStartIndex();
        int size = inv.getOutputGasContents().size();
        if (tanks.length < size) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            IGasHandlerItem handler;
            int index = cylinderIndex + i;
            GasTank tank = tanks[i];
            ItemStack stack = inv.m_8020_(index);
            if (tank.isEmpty() || stack.m_41619_() || (handler = (IGasHandlerItem)stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) == CapabilityUtils.EMPTY_GAS_ITEM) continue;
            for (int j = 0; j < handler.getTanks() && !tank.isEmpty(); ++j) {
                GasStack gas = tank.getGas();
                if (gas.getTemperature() > handler.getTankMaxTemperature(0) || gas.getPressure() > handler.getTankMaxPressure(0)) {
                    tile.m_58904_().m_5594_(null, tile.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                int taken = handler.fill(gas, GasAction.EXECUTE);
                tank.drain(taken, GasAction.EXECUTE);
            }
            inv.m_6836_(index, handler.getContainer());
        }
    }
}

