/*
 * Decompiled with CFR 0.152.
 */
package voltaic.datagen.utils.server.radiation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import voltaic.api.radiation.util.RadiationShielding;

public abstract class BaseRadiationShieldingProvider
implements DataProvider {
    private final PackOutput output;
    private final String modID;
    private final String loc;

    public BaseRadiationShieldingProvider(PackOutput output, String modID) {
        this.output = output;
        this.modID = modID;
        this.loc = "data/voltaic/radiation/" + modID + "_radiation_shielding";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        JsonObject json = new JsonObject();
        this.getRadiationShielding(json);
        Path parent = this.output.m_245114_().resolve(this.loc + ".json");
        return CompletableFuture.allOf(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)parent));
    }

    public abstract void getRadiationShielding(JsonObject var1);

    public void addBlock(Block block, double radiationAmount, double radiationLevel, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString(), (JsonElement)RadiationShielding.CODEC.encode((Object)new RadiationShielding(radiationAmount, radiationLevel), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public void addTag(TagKey<Block> tag, double radiationAmount, double radiationLevel, JsonObject json) {
        JsonObject data = new JsonObject();
        json.add("#" + tag.f_203868_().toString(), (JsonElement)RadiationShielding.CODEC.encode((Object)new RadiationShielding(radiationAmount, radiationLevel), (DynamicOps)JsonOps.INSTANCE, (Object)data).result().get());
    }

    public String m_6055_() {
        return this.modID + " Radiation Shielding Provider";
    }
}

