/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.variant;

import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.util.TriConsumer;
import voltaic.Voltaic;
import voltaic.prefab.properties.PropertyManager;
import voltaic.prefab.properties.types.ArrayPropertyType;
import voltaic.prefab.properties.types.IPropertyType;
import voltaic.prefab.properties.variant.AbstractProperty;

public class ArrayProperty<T>
extends AbstractProperty<T[], ArrayPropertyType<T, ?>> {
    private boolean alreadySynced = false;
    private TriConsumer<ArrayProperty<T>, T[], Integer> onChange = (prop, val, index) -> {};
    private Consumer<ArrayProperty<T>> onTileLoaded = prop -> {};

    public ArrayProperty(ArrayPropertyType<T, ?> type, String name, T[] defaultValue) {
        super(type, name, defaultValue);
    }

    @Override
    public void onTileLoaded() {
        this.onTileLoaded.accept(this);
    }

    @Override
    public void onLoadedFromTag(AbstractProperty<T[], ArrayPropertyType<T, ?>> prop, T[] loadedValue) {
        this.onChange.accept((Object)((ArrayProperty)prop), loadedValue, (Object)-1);
    }

    public ArrayProperty<T> onChange(TriConsumer<ArrayProperty<T>, T[], Integer> event) {
        this.onChange = event;
        return this;
    }

    public ArrayProperty<T> onTileLoaded(Consumer<ArrayProperty<T>> event) {
        this.onTileLoaded = this.onTileLoaded.andThen(event);
        return this;
    }

    @Override
    public void setValue(Object updated) {
        if (this.alreadySynced) {
            return;
        }
        Object[] old = (Object[])this.getValue();
        this.value = (Object[])updated;
        this.setDirty();
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, (Object)old, (Object)-1);
        }
    }

    public void setValue(Object updated, int index) {
        if (this.alreadySynced) {
            return;
        }
        this.checkForChange(updated, index);
        Object[] old = Arrays.copyOf((Object[])this.getValue(), ((Object[])this.getValue()).length);
        ((Object[])this.value)[index] = updated;
        PropertyManager manager = this.getPropertyManager();
        if (this.isDirty() && manager.getOwner().m_58904_() != null) {
            if (!manager.getOwner().m_58904_().m_5776_()) {
                if (this.shouldUpdateOnChange()) {
                    this.alreadySynced = true;
                    manager.getOwner().m_58904_().m_7260_(manager.getOwner().m_58899_(), manager.getOwner().m_58900_(), manager.getOwner().m_58900_(), 2);
                    manager.getOwner().m_6596_();
                    this.alreadySynced = false;
                }
                manager.setDirty(this);
            } else if (this.shouldUpdateServer()) {
                this.updateServer();
            }
            this.onChange.accept((Object)this, (Object)old, (Object)index);
        }
    }

    public void copy(ArrayProperty<T> other) {
        Object[] otherVal = (Object[])other.getValue();
        if (otherVal == null) {
            return;
        }
        this.overwriteValue(otherVal);
    }

    private boolean checkForChange(T updated, int index) {
        boolean shouldUpdate;
        boolean bl = shouldUpdate = ((Object[])this.value)[index] == null && updated != null;
        if (((Object[])this.value)[index] != null && updated != null) {
            boolean bl2 = shouldUpdate = !((ArrayPropertyType)this.getType()).isSingleEqual(((Object[])this.value)[index], updated);
        }
        if (shouldUpdate) {
            this.setDirty();
        }
        return shouldUpdate;
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        try {
            TYPE[] data = ((ArrayPropertyType)this.getType()).readFromTag(new IPropertyType.TagReader<TYPE[]>(this, tag));
            if (data != null) {
                this.value = data;
                this.onLoadedFromTag((AbstractProperty<T[], ArrayPropertyType<T, ?>>)this, (T[])((Object[])this.value));
            }
        }
        catch (Exception e) {
            Voltaic.LOGGER.info("Catching error while loading property " + this.getName() + " from NBT. Error: " + e.getMessage());
        }
    }
}

