/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.screen.component.types;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import voltaic.Voltaic;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.ScreenComponentGeneric;

public class ScreenComponentVerticalSlider
extends ScreenComponentGeneric {
    private int sliderYOffset = 0;
    private boolean active = false;
    private boolean isHeld = false;
    private Consumer<Integer> sliderDragConsumer;
    private Consumer<Integer> sliderClickConsumer;

    public ScreenComponentVerticalSlider(int x, int y, int height) {
        super(x, y, 14, Math.max(height, 30));
    }

    public ScreenComponentVerticalSlider setDragConsumer(Consumer<Integer> responder) {
        this.sliderDragConsumer = responder;
        return this;
    }

    public ScreenComponentVerticalSlider setClickConsumer(Consumer<Integer> responder) {
        this.sliderClickConsumer = responder;
        return this;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClick(button)) {
            this.onMouseDrag(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return false;
    }

    @Override
    public void onMouseDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.isHeld = true;
        if (this.sliderDragConsumer != null) {
            this.sliderDragConsumer.accept((int)(mouseY - this.gui.getGuiHeight()));
        }
        super.onMouseDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isHeld && this.isPointInSlider(this.xLocation, this.yLocation, mouseX - this.gui.getGuiWidth(), mouseY - this.gui.getGuiHeight(), this.width, this.height) && this.sliderClickConsumer != null) {
            this.sliderClickConsumer.accept((int)(mouseY - this.gui.getGuiHeight()));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isHeld = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected boolean isPointInRegion(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)(y + this.sliderYOffset + 2) && yAxis <= (double)(y + 2 + this.sliderYOffset + 15);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        VerticalSliderTextures bg = VerticalSliderTextures.SLIDER_BACKGROUND;
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation - 1, guiHeight + this.yLocation, this.width, 1, (float)bg.textureU(), (float)bg.textureV(), bg.textureWidth(), 1, bg.imageWidth(), bg.imageHeight());
        int permutations = (int)((double)(this.height - 2) / 28.0);
        int remainder = this.height - permutations * 28 - 2;
        for (int i = 0; i < permutations; ++i) {
            graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation - 1, guiHeight + this.yLocation + 1 + i * 28, this.width, 28, (float)bg.textureU(), (float)(bg.textureV() + 1), bg.textureWidth(), 28, bg.imageWidth(), bg.imageHeight());
        }
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation - 1, guiHeight + this.yLocation + 1 + 28 * permutations, this.width, remainder, (float)bg.textureU(), (float)(bg.textureV() + 1), bg.textureWidth(), remainder, bg.imageWidth(), bg.imageHeight());
        graphics.m_280411_(bg.getLocation(), guiWidth + this.xLocation - 1, guiHeight + this.yLocation + this.height - 1, this.width, 1, (float)bg.textureU(), (float)(bg.textureV() + 29), bg.textureWidth(), 1, bg.imageWidth(), bg.imageHeight());
        VerticalSliderTextures slider = this.active ? VerticalSliderTextures.SLIDER_ACTIVE : VerticalSliderTextures.SLIDER_INACTIVE;
        graphics.m_280411_(slider.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation + 1 + this.sliderYOffset, slider.textureWidth(), slider.textureHeight(), (float)slider.textureU(), (float)slider.textureV(), slider.textureWidth(), slider.textureHeight(), slider.imageWidth(), slider.imageHeight());
    }

    public void updateActive(boolean active) {
        this.active = active;
    }

    public void setSliderYOffset(int offset) {
        this.sliderYOffset = Math.min(offset, this.height - 2 - 15);
    }

    protected boolean isPointInSlider(int x, int y, double xAxis, double yAxis, int width, int height) {
        return xAxis >= (double)x && xAxis <= (double)(x + width - 1) && yAxis >= (double)y && yAxis <= (double)(y + height - 1);
    }

    public boolean isSliderActive() {
        return this.active;
    }

    public boolean isSliderHeld() {
        return this.isHeld;
    }

    public static enum VerticalSliderTextures implements ITexture
    {
        SLIDER_BACKGROUND(14, 30, 0, 0, 14, 30, Voltaic.rl("textures/screen/component/verticalslider/vertical_slider_bg.png")),
        SLIDER_ACTIVE(12, 15, 0, 0, 12, 15, Voltaic.rl("textures/screen/component/verticalslider/vertical_slider_active.png")),
        SLIDER_INACTIVE(12, 15, 0, 0, 12, 15, Voltaic.rl("textures/screen/component/verticalslider/vertical_slider_inactive.png"));

        private final int textureWidth;
        private final int textureHeight;
        private final int textureU;
        private final int textureV;
        private final int imageWidth;
        private final int imageHeight;
        private final ResourceLocation loc;

        private VerticalSliderTextures(int textureWidth, int textureHeight, int textureU, int textureV, int imageWidth, int imageHeight, ResourceLocation loc) {
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.textureU = textureU;
            this.textureV = textureV;
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.loc = loc;
        }

        @Override
        public ResourceLocation getLocation() {
            return this.loc;
        }

        @Override
        public int imageHeight() {
            return this.imageHeight;
        }

        @Override
        public int imageWidth() {
            return this.imageWidth;
        }

        @Override
        public int textureHeight() {
            return this.textureHeight;
        }

        @Override
        public int textureU() {
            return this.textureU;
        }

        @Override
        public int textureV() {
            return this.textureV;
        }

        @Override
        public int textureWidth() {
            return this.textureWidth;
        }
    }
}

