/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.HashSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;

public class ComponentFluidHandlerSimple
extends PropertyFluidTank
implements IComponentFluidHandler {
    @Nullable
    public Direction[] inputDirections;
    @Nullable
    public Direction[] outputDirections;
    @Nullable
    private TagKey<Fluid>[] validFluidTags;
    @Nullable
    private Fluid[] validFluids;
    private HashSet<Fluid> validatorFluids = new HashSet();
    private IFluidHandler[] sidedOptionals = new IFluidHandler[6];
    @Nullable
    private IFluidHandler inputOptional = null;
    @Nullable
    private IFluidHandler outputOptional = null;
    private boolean isSided = false;

    public ComponentFluidHandlerSimple(int capacity, Predicate<FluidStack> validator, GenericTile holder, String key) {
        super(capacity, validator, holder, key);
    }

    public ComponentFluidHandlerSimple(int capacity, GenericTile holder, String key) {
        super(capacity, holder, key);
    }

    protected ComponentFluidHandlerSimple(ComponentFluidHandlerSimple other) {
        super(other);
    }

    public ComponentFluidHandlerSimple setInputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.inputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        this.isSided = true;
        return this;
    }

    public ComponentFluidHandlerSimple setOutputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.outputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        this.isSided = true;
        return this;
    }

    @Override
    public ComponentFluidHandlerSimple setCapacity(int capacity) {
        return (ComponentFluidHandlerSimple)super.setCapacity(capacity);
    }

    public ComponentFluidHandlerSimple setValidator(Predicate<FluidStack> validator) {
        return (ComponentFluidHandlerSimple)super.setValidator(validator);
    }

    public ComponentFluidHandlerSimple setValidFluids(Fluid ... fluids) {
        this.validFluids = fluids;
        return this;
    }

    public ComponentFluidHandlerSimple setValidFluidTags(TagKey<Fluid> ... fluids) {
        this.validFluidTags = fluids;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentFluidHandlerSimple) {
            ComponentFluidHandlerSimple tank = (ComponentFluidHandlerSimple)obj;
            return tank.getFluid().equals((Object)this.getFluid()) && tank.getCapacity() == this.getCapacity();
        }
        return false;
    }

    @Override
    public IComponentType getType() {
        return IComponentType.FluidHandler;
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (this.isSided && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (!this.isSided) {
            return LazyOptional.of(() -> this).cast();
        }
        if (side == null) {
            return LazyOptional.empty();
        }
        IFluidHandler cap = this.sidedOptionals[side.ordinal()];
        return cap == null ? LazyOptional.empty() : LazyOptional.of(() -> cap).cast();
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.sidedOptionals = new IFluidHandler[6];
        this.inputOptional = null;
        this.outputOptional = null;
        if (this.isSided) {
            if (this.inputDirections != null) {
                this.inputOptional = new InputTank(this);
                for (Direction dir : this.inputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
                }
            }
            if (this.outputDirections != null) {
                this.outputOptional = new OutputTank(this);
                for (Direction dir : this.outputDirections) {
                    this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
                }
            }
        }
    }

    @Override
    public void onLoad() {
        IComponentFluidHandler.super.onLoad();
        if (this.validFluids != null) {
            for (Fluid fluid : this.validFluids) {
                this.validatorFluids.add(fluid);
            }
        }
        if (this.validFluidTags != null) {
            for (Fluid fluid : this.validFluidTags) {
                ((HolderSet.Named)BuiltInRegistries.f_257020_.m_203431_((TagKey)fluid).get()).m_203614_().forEach(holder -> this.validatorFluids.add((Fluid)holder.m_203334_()));
            }
        }
        if (!this.validatorFluids.isEmpty()) {
            this.validator = fluidStack -> this.validatorFluids.contains(fluidStack.getFluid());
        }
    }

    @Override
    public PropertyFluidTank[] getInputTanks() {
        return this.toArray();
    }

    @Override
    public PropertyFluidTank[] getOutputTanks() {
        return this.toArray();
    }

    public PropertyFluidTank[] toArray() {
        return new PropertyFluidTank[]{this};
    }

    private class InputTank
    extends ComponentFluidHandlerSimple {
        public InputTank(ComponentFluidHandlerSimple property) {
            super(property);
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutputTank
    extends ComponentFluidHandlerSimple {
        public OutputTank(ComponentFluidHandlerSimple property) {
            super(property);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }
    }
}

