/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.components.type;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.PropertyGasTank;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.recipeutils.AbstractMaterialRecipe;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.CapabilityInputType;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.utils.IComponentGasHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.MathUtils;
import voltaic.registers.VoltaicRegistries;

public class ComponentGasHandlerMulti
implements IComponentGasHandler {
    private GenericTile holder;
    @Nullable
    public Direction[] inputDirections;
    @Nullable
    public Direction[] outputDirections;
    private boolean isSided = false;
    private PropertyGasTank[] inputTanks = new PropertyGasTank[0];
    private PropertyGasTank[] outputTanks = new PropertyGasTank[0];
    @Nullable
    private RecipeType<? extends AbstractMaterialRecipe> recipeType;
    @Nullable
    private TagKey<Gas>[] validInputGasTags;
    @Nullable
    private Gas[] validInputGases;
    private HashSet<Gas> inputValidatorGases = new HashSet();
    @Nullable
    private TagKey<Gas>[] validOutputGasTags;
    @Nullable
    private Gas[] validOutputGases;
    private HashSet<Gas> outputValidatorGases = new HashSet();
    private IGasHandler[] sidedOptionals = new IGasHandler[6];
    @Nullable
    private IGasHandler inputOptional = null;
    @Nullable
    private IGasHandler outputOptional = null;

    public ComponentGasHandlerMulti(GenericTile holder) {
        this.holder = holder;
        if (!holder.m_58900_().m_61138_((Property)VoltaicBlockStates.FACING)) {
            throw new UnsupportedOperationException("The tile " + holder + " must have the FACING direction property!");
        }
    }

    public ComponentGasHandlerMulti setInputTanks(int count, int[] capacity, int[] maxTemperature, int[] maxPressure) {
        this.inputTanks = new PropertyGasTank[count];
        if (capacity.length < count) {
            throw new UnsupportedOperationException("The number of capacities does not match the number of input tanks");
        }
        if (maxPressure.length < count) {
            throw new UnsupportedOperationException("The number of max temperatures does not match the number of input tanks");
        }
        if (maxTemperature.length < count) {
            throw new UnsupportedOperationException("The number of max pressures does not match the number of input tanks");
        }
        for (int i = 0; i < count; ++i) {
            this.inputTanks[i] = new PropertyGasTank(this.holder, "input" + i, capacity[i], maxTemperature[i], maxPressure[i]);
        }
        return this;
    }

    public ComponentGasHandlerMulti setOutputTanks(int count, int[] capacity, int[] maxTemperature, int[] maxPressure) {
        this.outputTanks = new PropertyGasTank[count];
        if (capacity.length < count) {
            throw new UnsupportedOperationException("The number of capacities does not match the number of output tanks");
        }
        if (maxPressure.length < count) {
            throw new UnsupportedOperationException("The number of max temperatures does not match the number of output tanks");
        }
        if (maxTemperature.length < count) {
            throw new UnsupportedOperationException("The number of max pressures does not match the number of output tanks");
        }
        for (int i = 0; i < count; ++i) {
            this.outputTanks[i] = new PropertyGasTank(this.holder, "output" + i, capacity[i], maxTemperature[i], maxPressure[i]);
        }
        return this;
    }

    public ComponentGasHandlerMulti setTanks(int inputCount, int[] inputCapacity, int[] inputMaxTemperature, int[] inputMaxPressure, int outputCount, int[] outputCapacity, int[] outputMaxTemperature, int[] outputMaxPressure) {
        return this.setInputTanks(inputCount, inputCapacity, inputMaxTemperature, inputMaxPressure).setOutputTanks(outputCount, outputCapacity, outputMaxTemperature, outputMaxPressure);
    }

    public ComponentGasHandlerMulti setInputGases(Gas ... gases) {
        this.validInputGases = gases;
        return this;
    }

    public ComponentGasHandlerMulti setInputGasTags(TagKey<Gas> ... gases) {
        this.validInputGasTags = gases;
        return this;
    }

    public ComponentGasHandlerMulti setOutputGases(Gas ... gases) {
        this.validOutputGases = gases;
        return this;
    }

    public ComponentGasHandlerMulti setOutputGasTags(TagKey<Gas> ... gases) {
        this.validOutputGasTags = gases;
        return this;
    }

    public ComponentGasHandlerMulti setInputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.isSided = true;
        this.inputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        return this;
    }

    public ComponentGasHandlerMulti setOutputDirections(BlockEntityUtils.MachineDirection ... directions) {
        this.isSided = true;
        this.outputDirections = BlockEntityUtils.MachineDirection.toDirectionArray(directions);
        return this;
    }

    public ComponentGasHandlerMulti setRecipeType(RecipeType<? extends AbstractMaterialRecipe> recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public ComponentGasHandlerMulti setCondensedHandler(BiConsumer<GasTank, GenericTile> consumer) {
        for (PropertyGasTank tank : this.inputTanks) {
            tank.setOnGasCondensed(consumer);
        }
        for (PropertyGasTank tank : this.outputTanks) {
            tank.setOnGasCondensed(consumer);
        }
        return this;
    }

    public int tankCount(boolean input) {
        if (input) {
            return this.inputTanks == null ? 0 : this.inputTanks.length;
        }
        return this.outputTanks == null ? 0 : this.outputTanks.length;
    }

    public GasStack getGasInTank(int tank, boolean input) {
        if (input) {
            return this.inputTanks[tank].getGas();
        }
        return this.outputTanks[tank].getGas();
    }

    @Nullable
    public PropertyGasTank getTankFromGas(Gas gas, boolean isInput) {
        if (isInput) {
            for (PropertyGasTank tank : this.inputTanks) {
                if (!tank.getGas().getGas().equals(gas)) continue;
                return tank;
            }
            for (PropertyGasTank tank : this.inputTanks) {
                if (!tank.isEmpty()) continue;
                return tank;
            }
        }
        for (PropertyGasTank tank : this.outputTanks) {
            if (!tank.getGas().getGas().equals(gas)) continue;
            return tank;
        }
        for (PropertyGasTank tank : this.outputTanks) {
            if (!tank.isEmpty()) continue;
            return tank;
        }
        return null;
    }

    public int getTankCapacity(int tank, boolean input) {
        if (input) {
            return this.inputTanks[tank].getCapacity();
        }
        return this.outputTanks[tank].getCapacity();
    }

    public boolean isGasValid(int tank, @NotNull GasStack stack, boolean input) {
        if (input) {
            return this.inputTanks[tank].isGasValid(stack);
        }
        return this.outputTanks[tank].isGasValid(stack);
    }

    public int fill(int tank, GasStack resource, GasAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].fill(resource, action);
        }
        return this.outputTanks[tank].fill(resource, action);
    }

    @NotNull
    public GasStack drain(int tank, GasStack resource, GasAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].drain(resource, action);
        }
        return this.outputTanks[tank].drain(resource, action);
    }

    @NotNull
    public GasStack drain(int tank, int maxDrain, GasAction action, boolean input) {
        if (input) {
            return this.inputTanks[tank].drain(maxDrain, action);
        }
        return this.outputTanks[tank].drain(maxDrain, action);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side, CapabilityInputType inputType) {
        if (side == null || !this.isSided) {
            return LazyOptional.empty();
        }
        IGasHandler cap = this.sidedOptionals[side.ordinal()];
        return cap == null ? LazyOptional.empty() : LazyOptional.of(() -> cap).cast();
    }

    @Override
    public void refreshIfUpdate(BlockState oldState, BlockState newState) {
        if (this.isSided && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.defineOptionals((Direction)newState.m_61143_((Property)VoltaicBlockStates.FACING));
        }
    }

    @Override
    public void refresh() {
        this.defineOptionals(this.holder.getFacing());
    }

    private void defineOptionals(Direction facing) {
        this.holder.invalidateCaps();
        this.sidedOptionals = new IGasHandler[6];
        this.inputOptional = null;
        this.outputOptional = null;
        if (this.inputDirections != null) {
            this.inputOptional = new InputTankDispatcher(this.inputTanks);
            for (Direction dir : this.inputDirections) {
                this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.inputOptional;
            }
        }
        if (this.outputDirections != null) {
            this.outputOptional = new OutputTankDispatcher(this.outputTanks);
            for (Direction dir : this.outputDirections) {
                this.sidedOptionals[BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)dir).ordinal()] = this.outputOptional;
            }
        }
    }

    @Override
    public void holder(GenericTile holder) {
        this.holder = holder;
    }

    @Override
    public GenericTile getHolder() {
        return this.holder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLoad() {
        IComponentGasHandler.super.onLoad();
        if (this.recipeType != null) {
            List<VoltaicRecipe> recipes = VoltaicRecipe.findRecipesbyType(this.recipeType, this.holder.m_58904_());
            ArrayList inputGasHolder = new ArrayList();
            ArrayList<Gas> outputGasHolder = new ArrayList<Gas>();
            double d = 0.0;
            double maxGasInputTemperature = 0.0;
            int maxGasInputPressure = 0;
            double maxGasOutputAmount = 0.0;
            double maxGasOutputTemperature = 0.0;
            int maxGasOutputPressure = 0;
            double maxGasBiproductAmount = 0.0;
            double maxGasBiproductTemperature = 0.0;
            int maxGasBiproudctPressure = 0;
            for (VoltaicRecipe voltaicRecipe : recipes) {
                AbstractMaterialRecipe recipe = (AbstractMaterialRecipe)voltaicRecipe;
                if (this.inputTanks != null) {
                    for (GasIngredient gasIngredient : recipe.getGasIngredients()) {
                        gasIngredient.getMatchingGases().forEach(h -> inputGasHolder.add(h.getGas()));
                        GasStack gas = gasIngredient.getGasStack();
                        if ((double)gas.getAmount() > d) {
                            d = gas.getAmount();
                        }
                        if ((double)gas.getTemperature() > maxGasInputTemperature) {
                            maxGasInputTemperature = gas.getTemperature();
                        }
                        if (gas.getPressure() <= maxGasInputPressure) continue;
                        maxGasInputPressure = gas.getPressure();
                    }
                }
                if (this.outputTanks == null) continue;
                GasStack output = recipe.getGasRecipeOutput();
                outputGasHolder.add(output.getGas());
                if ((double)output.getAmount() > maxGasOutputAmount) {
                    maxGasOutputAmount = output.getAmount();
                }
                if ((double)output.getTemperature() > maxGasOutputTemperature) {
                    maxGasOutputTemperature = output.getTemperature();
                }
                if (output.getPressure() > maxGasOutputPressure) {
                    maxGasOutputPressure = output.getPressure();
                }
                if (!recipe.hasGasBiproducts()) continue;
                for (GasStack stack : recipe.getFullGasBiStacks()) {
                    outputGasHolder.add(stack.getGas());
                    if ((double)stack.getAmount() > maxGasBiproductAmount) {
                        maxGasBiproductAmount = stack.getAmount();
                    }
                    if ((double)stack.getTemperature() > maxGasBiproductTemperature) {
                        maxGasBiproductTemperature = stack.getTemperature();
                    }
                    if (stack.getPressure() <= maxGasBiproudctPressure) continue;
                    maxGasBiproudctPressure = stack.getPressure();
                }
            }
            this.inputValidatorGases.addAll(inputGasHolder);
            this.outputValidatorGases.addAll(outputGasHolder);
            if (d > 0.0) {
                d = d / 1000.0 * 1000.0 + 1000.0;
                int logged = MathUtils.logBase2(maxGasInputPressure);
                maxGasInputPressure = (int)Math.pow(2.0, ++logged);
                for (PropertyGasTank propertyGasTank : this.inputTanks) {
                    if ((double)propertyGasTank.getCapacity() < d) {
                        propertyGasTank.setCapacity((int)d);
                    }
                    if ((double)propertyGasTank.getMaxTemperature() < maxGasInputTemperature) {
                        propertyGasTank.setMaxTemperature((int)(maxGasInputTemperature + 10.0));
                    }
                    if (propertyGasTank.getMaxPressure() >= maxGasInputPressure) continue;
                    propertyGasTank.setMaxPressure(maxGasInputPressure);
                }
            }
            int offset = 0;
            if (maxGasOutputAmount > 0.0) {
                maxGasOutputAmount = maxGasOutputAmount / 1000.0 * 1000.0 + 1000.0;
                PropertyGasTank propertyGasTank = this.outputTanks[0];
                int logged = MathUtils.logBase2(maxGasOutputPressure);
                maxGasOutputPressure = (int)Math.pow(2.0, ++logged);
                if ((double)propertyGasTank.getCapacity() < maxGasOutputAmount) {
                    propertyGasTank.setCapacity((int)maxGasOutputAmount);
                }
                if ((double)propertyGasTank.getMaxTemperature() < maxGasOutputTemperature) {
                    propertyGasTank.setMaxTemperature((int)(maxGasOutputTemperature + 10.0));
                }
                if (propertyGasTank.getMaxPressure() < maxGasOutputPressure) {
                    propertyGasTank.setMaxPressure(maxGasOutputPressure);
                }
                offset = 1;
            }
            if (maxGasBiproductAmount > 0.0) {
                void var20_38;
                maxGasBiproductAmount = maxGasBiproductAmount / 1000.0 * 1000.0 + 1000.0;
                int n = MathUtils.logBase2(maxGasBiproudctPressure);
                maxGasBiproudctPressure = (int)Math.pow(2.0, (double)(++var20_38));
                for (int i = 0; i < this.outputTanks.length - offset; ++i) {
                    PropertyGasTank tank = this.outputTanks[i + offset];
                    if ((double)tank.getCapacity() < maxGasBiproductAmount) {
                        tank.setCapacity((int)maxGasBiproductAmount);
                    }
                    if ((double)tank.getMaxTemperature() < maxGasBiproductTemperature) {
                        tank.setMaxTemperature((int)(maxGasBiproductTemperature + 10.0));
                    }
                    if (tank.getMaxPressure() >= maxGasBiproudctPressure) continue;
                    tank.setMaxPressure(maxGasBiproudctPressure);
                }
            }
        } else {
            if (this.validInputGases != null) {
                for (Gas gas : this.validInputGases) {
                    this.inputValidatorGases.add(gas);
                }
            }
            if (this.validInputGasTags != null) {
                for (Gas gas : this.validInputGasTags) {
                    for (Gas fluid : VoltaicRegistries.gasRegistry().tags().getTag((TagKey)gas).stream().toList()) {
                        this.inputValidatorGases.add(fluid);
                    }
                }
            }
            if (this.validOutputGases != null) {
                for (Gas gas : this.validOutputGases) {
                    this.outputValidatorGases.add(gas);
                }
            }
            if (this.validOutputGasTags != null) {
                for (TagKey<Gas> tagKey : this.validOutputGasTags) {
                    for (Gas fluid : VoltaicRegistries.gasRegistry().tags().getTag((TagKey)tagKey).stream().toList()) {
                        this.outputValidatorGases.add(fluid);
                    }
                }
            }
        }
        if (!this.inputValidatorGases.isEmpty()) {
            for (PropertyGasTank propertyGasTank : this.inputTanks) {
                propertyGasTank.setValidator(gasStack -> this.inputValidatorGases.contains(gasStack.getGas()));
            }
        }
        if (!this.outputValidatorGases.isEmpty()) {
            for (PropertyGasTank propertyGasTank : this.outputTanks) {
                propertyGasTank.setValidator(gasStack -> this.outputValidatorGases.contains(gasStack.getGas()));
            }
        }
    }

    @Override
    public IComponentType getType() {
        return IComponentType.GasHandler;
    }

    @Override
    public PropertyGasTank[] getInputTanks() {
        return this.inputTanks;
    }

    @Override
    public PropertyGasTank[] getOutputTanks() {
        return this.outputTanks;
    }

    private class InputTankDispatcher
    implements IGasHandler {
        private PropertyGasTank[] tanks;

        public InputTankDispatcher(PropertyGasTank[] tanks) {
            this.tanks = tanks;
        }

        @Override
        public int getTanks() {
            return this.tanks.length;
        }

        @Override
        public GasStack getGasInTank(int tank) {
            return this.tanks[tank].getGas();
        }

        @Override
        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        @Override
        public int getTankMaxTemperature(int tank) {
            return this.tanks[tank].getMaxTemperature();
        }

        @Override
        public int getTankMaxPressure(int tank) {
            return this.tanks[tank].getMaxPressure();
        }

        @Override
        public boolean isGasValid(int tank, GasStack gas) {
            return this.tanks[tank].isGasValid(gas);
        }

        @Override
        public int fill(GasStack gas, GasAction action) {
            for (PropertyGasTank tank : this.tanks) {
                if (!tank.getGas().is(gas.getGas())) continue;
                return tank.fill(gas, action);
            }
            for (PropertyGasTank tank : this.tanks) {
                if (!tank.isEmpty()) continue;
                return tank.fill(gas, action);
            }
            return 0;
        }

        @Override
        public GasStack drain(GasStack gas, GasAction action) {
            return GasStack.EMPTY;
        }

        @Override
        public GasStack drain(int maxFill, GasAction action) {
            return GasStack.EMPTY;
        }

        @Override
        public int heat(int tank, int deltaTemperature, GasAction action) {
            return this.tanks[tank].heat(tank, deltaTemperature, action);
        }

        @Override
        public int bringPressureTo(int tank, int atm, GasAction action) {
            return this.tanks[tank].bringPressureTo(tank, atm, action);
        }
    }

    private class OutputTankDispatcher
    implements IGasHandler {
        private PropertyGasTank[] tanks;

        public OutputTankDispatcher(PropertyGasTank[] tanks) {
            this.tanks = tanks;
        }

        @Override
        public int getTanks() {
            return this.tanks.length;
        }

        @Override
        public GasStack getGasInTank(int tank) {
            return this.tanks[tank].getGas();
        }

        @Override
        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        @Override
        public int getTankMaxTemperature(int tank) {
            return this.tanks[tank].getMaxTemperature();
        }

        @Override
        public int getTankMaxPressure(int tank) {
            return this.tanks[tank].getMaxPressure();
        }

        @Override
        public boolean isGasValid(int tank, GasStack gas) {
            return false;
        }

        @Override
        public int fill(GasStack gas, GasAction action) {
            return 0;
        }

        @Override
        public GasStack drain(GasStack gas, GasAction action) {
            for (PropertyGasTank tank : this.tanks) {
                if (!tank.getGas().is(gas.getGas())) continue;
                return tank.drain(gas, action);
            }
            return GasStack.EMPTY;
        }

        @Override
        public GasStack drain(int maxFill, GasAction action) {
            return GasStack.EMPTY;
        }

        @Override
        public int heat(int tank, int deltaTemperature, GasAction action) {
            return this.tanks[tank].heat(tank, deltaTemperature, action);
        }

        @Override
        public int bringPressureTo(int tank, int atm, GasAction action) {
            return this.tanks[tank].bringPressureTo(tank, atm, action);
        }
    }
}

