/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.tile.types;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.network.cable.IRefreshableCable;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.network.AbstractNetwork;
import voltaic.prefab.tile.types.GenericConnectTile;
import voltaic.prefab.utilities.Scheduler;

public abstract class GenericRefreshingConnectTile<CABLETYPE, CONDUCTOR extends GenericRefreshingConnectTile<CABLETYPE, CONDUCTOR, NETWORK>, NETWORK extends AbstractNetwork<CONDUCTOR, CABLETYPE, ?, NETWORK>>
extends GenericConnectTile
implements IRefreshableCable<CABLETYPE, NETWORK> {
    private final EnumConnectType[] previousConnections = new EnumConnectType[]{EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE, EnumConnectType.NONE};
    protected final BlockEntity[] recieverConnections = new BlockEntity[6];
    protected final BlockEntity[] prevRecieverConnections = new BlockEntity[6];
    protected final BlockEntity[] cableConnections = new BlockEntity[6];
    protected final BlockEntity[] prevCableConnections = new BlockEntity[6];
    protected final HashSet<CONDUCTOR> connectionSet = new HashSet();
    private NETWORK network;
    public boolean isQueued = false;

    public GenericRefreshingConnectTile(BlockEntityType<?> tile, BlockPos pos, BlockState state) {
        super(tile, pos, state);
    }

    public Pair<List<UpdatedReceiver>, List<UpdatedConductor<CONDUCTOR>>> updateAdjacent(Direction[] dirs) {
        boolean flag = false;
        ArrayList<UpdatedReceiver> updatedRecievers = new ArrayList<UpdatedReceiver>();
        ArrayList<UpdatedConductor<GenericRefreshingConnectTile>> updatedConductors = new ArrayList<UpdatedConductor<GenericRefreshingConnectTile>>();
        for (Direction direction : dirs) {
            int ordinal = direction.ordinal();
            EnumConnectType connection = this.connectionsArr[ordinal];
            EnumConnectType prevConnection = this.previousConnections[ordinal];
            BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (prevConnection == connection) continue;
            if (connection == EnumConnectType.NONE && prevConnection == EnumConnectType.WIRE) {
                updatedConductors.add(new UpdatedConductor<GenericRefreshingConnectTile>((GenericRefreshingConnectTile)this.prevCableConnections[ordinal], true));
            } else if (connection == EnumConnectType.WIRE && prevConnection == EnumConnectType.NONE) {
                updatedConductors.add(new UpdatedConductor<GenericRefreshingConnectTile>((GenericRefreshingConnectTile)entity, false));
            } else if (connection == EnumConnectType.NONE && prevConnection == EnumConnectType.INVENTORY) {
                updatedRecievers.add(new UpdatedReceiver(this.prevRecieverConnections[ordinal], true, direction));
            } else if (connection == EnumConnectType.INVENTORY && prevConnection == EnumConnectType.NONE) {
                updatedRecievers.add(new UpdatedReceiver(entity, false, direction));
            }
            this.prevCableConnections[ordinal] = this.cableConnections[ordinal];
            this.prevRecieverConnections[ordinal] = this.recieverConnections[ordinal];
            this.recieverConnections[ordinal] = null;
            this.cableConnections[ordinal] = null;
            if (connection == EnumConnectType.WIRE) {
                this.cableConnections[ordinal] = entity;
            } else if (connection == EnumConnectType.INVENTORY) {
                this.recieverConnections[ordinal] = entity;
            }
            this.previousConnections[ordinal] = connection;
            flag = true;
        }
        if (flag) {
            this.connectionSet.clear();
            for (Direction direction : this.cableConnections) {
                if (direction == null) continue;
                this.connectionSet.add((GenericRefreshingConnectTile)direction);
            }
        }
        return Pair.of(updatedRecievers, updatedConductors);
    }

    @Override
    public NETWORK getNetwork() {
        if (this.network == null) {
            this.createNetworkFromThis();
        }
        return this.network;
    }

    @Override
    public void createNetworkFromThis() {
        this.network = this.createInstanceConductor(Sets.newHashSet((Object[])new GenericRefreshingConnectTile[]{this}));
        ((AbstractNetwork)this.network).refreshNewNetwork();
    }

    @Override
    public void setNetwork(NETWORK network) {
        if (this.network == null) {
            this.network = network;
        } else if (!((AbstractNetwork)this.network).equals(network)) {
            this.removeFromNetwork();
            this.network = network;
        }
    }

    @Override
    public void updateNetwork(Direction ... dirs) {
        if (this.m_58901_()) {
            return;
        }
        if (this.f_58857_ == null && !this.isQueued) {
            this.isQueued = true;
            Scheduler.schedule(1, () -> this.updateNetwork(dirs));
        }
        this.isQueued = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        Pair<List<UpdatedReceiver>, List<UpdatedConductor<CONDUCTOR>>> changed = this.updateAdjacent(dirs);
        if (((List)changed.getSecond()).isEmpty()) {
            if (this.network == null) {
                this.createNetworkFromThis();
            }
            if (!((List)changed.getFirst()).isEmpty()) {
                ((AbstractNetwork)this.network).updateRecievers((List)changed.getFirst());
            }
        } else {
            HashSet<NETWORK> adjacentNetworks = new HashSet<NETWORK>();
            for (UpdatedConductor wire : (List)changed.getSecond()) {
                if (wire.conductor() == null || ((GenericRefreshingConnectTile)wire.conductor()).m_58901_() || ((GenericRefreshingConnectTile)wire.conductor()).getNetwork() == null) continue;
                adjacentNetworks.add(((GenericRefreshingConnectTile)wire.conductor()).getNetwork());
            }
            if (adjacentNetworks.isEmpty()) {
                if (this.network == null) {
                    this.createNetworkFromThis();
                }
                ((AbstractNetwork)this.network).updateConductors((List)changed.getSecond());
            } else {
                ArrayList networks = new ArrayList(adjacentNetworks);
                if (networks.size() > 1) {
                    if (this.network == null) {
                        this.createNetworkFromThis();
                    }
                    adjacentNetworks.add(this.network);
                    newNetwork = this.createInstance(adjacentNetworks);
                    this.network = newNetwork;
                    ((AbstractNetwork)newNetwork).refreshNewNetwork();
                } else if (this.network == null) {
                    this.network = (AbstractNetwork)networks.get(0);
                    ((AbstractNetwork)this.network).updateConductor((GenericRefreshingConnectTile)this, false);
                } else {
                    adjacentNetworks.add(this.network);
                    newNetwork = this.createInstance(adjacentNetworks);
                    this.network = newNetwork;
                    ((AbstractNetwork)newNetwork).refreshNewNetwork();
                }
            }
        }
    }

    @Override
    public void removeFromNetwork() {
        if (this.network != null) {
            ((AbstractNetwork)this.network).removeFromNetwork((GenericRefreshingConnectTile)this);
        }
    }

    @Override
    public BlockEntity[] getConectedRecievers() {
        return this.recieverConnections;
    }

    @Override
    public BlockEntity[] getConnectedCables() {
        return this.cableConnections;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.f_58857_.f_46443_ && this.network != null) {
            ((AbstractNetwork)this.getNetwork()).split((GenericRefreshingConnectTile)this);
        }
    }

    public void onChunkUnloaded() {
        if (!this.f_58857_.f_46443_ && this.network != null) {
            ((AbstractNetwork)this.getNetwork()).split((GenericRefreshingConnectTile)this);
        }
        super.onChunkUnloaded();
    }

    public abstract NETWORK createInstanceConductor(Set<CONDUCTOR> var1);

    public abstract NETWORK createInstance(Set<NETWORK> var1);

    @Override
    public void onLoad() {
        super.onLoad();
        Scheduler.schedule(2, () -> this.updateNetwork(Direction.values()));
    }

    public record UpdatedConductor<CONDUCTOR>(CONDUCTOR conductor, boolean removed) {
    }

    public record UpdatedReceiver(BlockEntity reciever, boolean removed, Direction dir) {
    }
}

