/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveFluidRegister;
import voltaic.common.reloadlistener.RadioactiveGasRegister;
import voltaic.common.reloadlistener.RadioactiveItemRegister;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;

public class RadiationUtils {
    public static void handleRadioactiveGases(GenericTile tile, ComponentGasHandlerMulti multi, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        RadiationUtils.handleRadioactiveGases(tile, multi.getInputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
        RadiationUtils.handleRadioactiveGases(tile, multi.getOutputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
    }

    public static void handleRadioactiveGases(GenericTile tile, ComponentGasHandlerSimple simple, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        RadiationUtils.handleRadioactiveGases(tile, simple.getInputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
    }

    public static void handleRadioactiveGases(GenericTile tile, GasTank[] tanks, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        double totRadiation = 0.0;
        double totStrength = 0.0;
        for (GasTank tank : tanks) {
            GasStack gas;
            RadioactiveObject rads;
            if (tank.isEmpty() || (rads = RadioactiveGasRegister.getValue((gas = tank.getGas()).getGas())).amount() <= 0.0) continue;
            totRadiation += rads.amount() * (double)gas.getAmount() * (double)gas.getPressure();
            totStrength = Math.max(totStrength, rads.strength());
        }
        if (totRadiation <= 0.0) {
            return;
        }
        RadiationSystem.addRadiationSource(tile.m_58904_(), new SimpleRadiationSource(totRadiation, totStrength, radius, isTemp, ticks, tile.m_58899_(), shouldLinger, shouldCombine));
    }

    public static void handleRadioactiveFluids(GenericTile tile, ComponentFluidHandlerMulti multi, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        RadiationUtils.handleRadioactiveFluids(tile, multi.getInputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
        RadiationUtils.handleRadioactiveFluids(tile, multi.getOutputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
    }

    public static void handleRadioactiveFluids(GenericTile tile, ComponentFluidHandlerSimple simple, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        RadiationUtils.handleRadioactiveFluids(tile, simple.getInputTanks(), radius, isTemp, ticks, shouldLinger, shouldCombine);
    }

    public static void handleRadioactiveFluids(GenericTile tile, FluidTank[] tanks, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        double totRadiation = 0.0;
        double totStrength = 0.0;
        for (FluidTank tank : tanks) {
            FluidStack fluid;
            RadioactiveObject rads;
            if (tank.isEmpty() || (rads = RadioactiveFluidRegister.getValue((fluid = tank.getFluid()).getFluid())).amount() <= 0.0) continue;
            totRadiation += rads.amount() * (double)fluid.getAmount();
            totStrength = Math.max(totStrength, rads.strength());
        }
        if (totRadiation <= 0.0) {
            return;
        }
        RadiationSystem.addRadiationSource(tile.m_58904_(), new SimpleRadiationSource(totRadiation, totStrength, radius, isTemp, ticks, tile.m_58899_(), shouldLinger, shouldCombine));
    }

    public static void handleRadioactiveItems(GenericTile tile, ComponentInventory inv, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        RadiationUtils.handleRadioactiveItems(tile, inv.getInputContents(), radius, isTemp, ticks, shouldLinger, shouldCombine);
        RadiationUtils.handleRadioactiveItems(tile, inv.getOutputContents(), radius, isTemp, ticks, shouldLinger, shouldCombine);
    }

    public static void handleRadioactiveItems(GenericTile tile, List<ItemStack> items, int radius, boolean isTemp, int ticks, boolean shouldLinger, boolean shouldCombine) {
        double totRadiation = 0.0;
        double totStrength = 0.0;
        for (ItemStack item : items) {
            RadioactiveObject rads;
            if (item.m_41619_() || (rads = RadioactiveItemRegister.getValue(item.m_41720_())).amount() <= 0.0) continue;
            totRadiation += rads.amount() * (double)item.m_41613_();
            totStrength = Math.max(totStrength, rads.strength());
        }
        if (totRadiation <= 0.0) {
            return;
        }
        RadiationSystem.addRadiationSource(tile.m_58904_(), new SimpleRadiationSource(totRadiation, totStrength, radius, isTemp, ticks, tile.m_58899_(), shouldLinger, shouldCombine));
    }
}

