/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.utilities.math;

import org.joml.Vector3f;

public class Color {
    public static final Color WHITE = new Color(-1);
    public static final Color BLACK = new Color(0, 0, 0, 0);
    public static final Color TEXT_GRAY = new Color(64, 64, 64, 255);
    public static final Color JEI_TEXT_GRAY = new Color(128, 128, 128, 255);
    private final int r;
    private final int g;
    private final int b;
    private final int a;
    private final float rFloat;
    private final float gFloat;
    private final float bFloat;
    private final float aFloat;
    private final int color;
    private final int[] colorArr;
    private final float[] colorFloatArr;
    private final Vector3f floatVector;

    public Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.rFloat = (float)this.r / 256.0f;
        this.gFloat = (float)this.g / 256.0f;
        this.bFloat = (float)this.b / 256.0f;
        this.aFloat = (float)this.a / 256.0f;
        this.color = (this.a << 24) + (this.r << 16) + (this.g << 8) + this.b;
        this.colorArr = new int[]{this.r, this.g, this.b, this.a};
        this.colorFloatArr = new float[]{this.rFloat, this.gFloat, this.bFloat, this.aFloat};
        this.floatVector = new Vector3f(this.rFloat, this.gFloat, this.bFloat);
    }

    public Color(int argb) {
        this(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public Color(float r, float g, float b, float a) {
        this((int)(r * 256.0f), (int)(g * 256.0f), (int)(b * 256.0f), (int)(a * 256.0f));
    }

    public Color(int[] colorArr) {
        this(colorArr[0], colorArr[1], colorArr[2], colorArr[3]);
    }

    public Color(float[] colorFloatArr) {
        this(colorFloatArr[0], colorFloatArr[1], colorFloatArr[2], colorFloatArr[3]);
    }

    public int r() {
        return this.r;
    }

    public int g() {
        return this.g;
    }

    public int b() {
        return this.b;
    }

    public int a() {
        return this.a;
    }

    public float rFloat() {
        return this.rFloat;
    }

    public float gFloat() {
        return this.gFloat;
    }

    public float bFloat() {
        return this.bFloat;
    }

    public float aFloat() {
        return this.aFloat;
    }

    public int color() {
        return this.color;
    }

    public int[] colorArr() {
        return this.colorArr;
    }

    public float[] colorFloatArr() {
        return this.colorFloatArr;
    }

    public Vector3f getFloatVector() {
        return this.floatVector;
    }

    public Color multiply(Color other) {
        return new Color(this.r * other.r / 255, this.g * other.g / 255, this.b * other.b / 255, this.a * other.a / 255);
    }

    public Color blend(Color other, double amtOther) {
        double amtThis = 1.0 - amtOther;
        return new Color((int)((double)this.r * amtThis + (double)other.r * amtOther), (int)((double)this.g * amtThis + (double)other.g * amtOther), (int)((double)this.b * amtThis + (double)other.b * amtOther), (int)((double)this.a * amtThis + (double)other.a * amtOther));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Color) {
            Color other = (Color)obj;
            return this.r == other.r && this.g == other.g && this.b == other.b && this.a == other.a;
        }
        return false;
    }

    public String toString() {
        return "r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", a: " + this.a;
    }

    public static Color fromABGR(int abgr) {
        return new Color(abgr & 0xFF, abgr >> 8 & 0xFF, abgr >> 16 & 0xFF, abgr >> 24 & 0xFF);
    }
}

