/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.context;

import java.lang.ref.WeakReference;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class AquiferContext {
    private static final ThreadLocal<AquiferContext> CONTEXT = new ThreadLocal();
    private final WeakReference<ServerLevel> serverLevel;

    public AquiferContext(ServerLevel serverLevel) {
        this.serverLevel = new WeakReference<ServerLevel>(serverLevel);
    }

    public ServerLevel getServerLevel() {
        return (ServerLevel)this.serverLevel.get();
    }

    @Nullable
    public static AquiferContext pop() {
        AquiferContext context = CONTEXT.get();
        CONTEXT.remove();
        return context;
    }

    @Nullable
    public static AquiferContext peek() {
        return CONTEXT.get();
    }

    public static void push(ServerLevel world) {
        CONTEXT.set(new AquiferContext(world));
    }
}

