/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.ValueDefinition;

public class CheckboxButton
extends Button {
    private final ResourceLocation iconsTexture;
    private final ValueDefinition<Boolean> value;
    private final ChangeSet changes;

    public CheckboxButton(ResourceLocation iconsTexture, int x, int y, ChangeSet changes, ValueDefinition<Boolean> value) {
        super(new Button.Builder((Component)Component.m_237113_((String)""), CheckboxButton::toggle).m_252794_(x, y).m_253046_(20, 20));
        this.iconsTexture = iconsTexture;
        this.value = value;
        this.changes = changes;
    }

    public CheckboxButton(ZetaClient zc, int x, int y, ChangeSet changes, ValueDefinition<Boolean> value) {
        this(zc.generalIcons, x, y, changes, value);
    }

    private static void toggle(Button press) {
        if (press instanceof CheckboxButton) {
            CheckboxButton checkbox = (CheckboxButton)press;
            checkbox.changes.toggle(checkbox.value);
        }
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partial);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean enabled = this.changes.get(this.value) != false && this.f_93623_;
        int u = enabled ? 0 : 16;
        int v = 0;
        guiGraphics.m_280218_(this.iconsTexture, this.m_252754_() + 2, this.m_252907_() + 1, u, v, 15, 15);
    }
}

