/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.utils;

import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MethodNodeHasher {
    private static final int FNV_PRIME = 16777619;

    public static synchronized int hash(MethodNode method) {
        int hash = -2128831035;
        IdentityHashMap<LabelNode, Integer> labelIds = new IdentityHashMap<LabelNode, Integer>();
        int[] labelCounter = new int[]{0};
        block14: for (AbstractInsnNode insn : method.instructions) {
            if (insn instanceof LineNumberNode || insn instanceof FrameNode) continue;
            if (insn instanceof LabelNode) {
                labelIds.computeIfAbsent((LabelNode)insn, k -> {
                    int n = labelCounter[0];
                    labelCounter[0] = n + 1;
                    return n;
                });
                continue;
            }
            hash = MethodNodeHasher.fnvUpdate(hash, insn.getOpcode());
            switch (insn.getType()) {
                case 2: {
                    hash = MethodNodeHasher.fnvUpdate(hash, ((VarInsnNode)insn).var);
                    break;
                }
                case 4: {
                    FieldInsnNode f = (FieldInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, f.owner);
                    hash = MethodNodeHasher.fnvUpdate(hash, f.name);
                    hash = MethodNodeHasher.fnvUpdate(hash, f.desc);
                    break;
                }
                case 5: {
                    MethodInsnNode m = (MethodInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, m.owner);
                    hash = MethodNodeHasher.fnvUpdate(hash, m.name);
                    hash = MethodNodeHasher.fnvUpdate(hash, m.desc);
                    hash = MethodNodeHasher.fnvUpdate(hash, m.itf ? 1 : 0);
                    break;
                }
                case 9: {
                    Object cst = ((LdcInsnNode)insn).cst;
                    MethodNodeHasher.updateLdcConstant(hash, cst);
                    hash = MethodNodeHasher.updateLdcConstant(hash, cst);
                    break;
                }
                case 1: {
                    hash = MethodNodeHasher.fnvUpdate(hash, ((IntInsnNode)insn).operand);
                    break;
                }
                case 3: {
                    hash = MethodNodeHasher.fnvUpdate(hash, ((TypeInsnNode)insn).desc);
                    break;
                }
                case 7: {
                    JumpInsnNode j = (JumpInsnNode)insn;
                    int labelId = labelIds.computeIfAbsent(j.label, k -> {
                        int n = labelCounter[0];
                        labelCounter[0] = n + 1;
                        return n;
                    });
                    hash = MethodNodeHasher.fnvUpdate(hash, labelId);
                    break;
                }
                case 10: {
                    IincInsnNode iinc = (IincInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, iinc.var);
                    hash = MethodNodeHasher.fnvUpdate(hash, iinc.incr);
                    break;
                }
                case 6: {
                    InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, indy.name);
                    hash = MethodNodeHasher.fnvUpdate(hash, indy.desc);
                    hash = MethodNodeHasher.fnvUpdate(hash, indy.bsm.toString());
                    for (Object arg : indy.bsmArgs) {
                        hash = MethodNodeHasher.fnvUpdate(hash, String.valueOf(arg));
                    }
                    continue block14;
                }
                case 13: {
                    MultiANewArrayInsnNode multi = (MultiANewArrayInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, multi.desc);
                    hash = MethodNodeHasher.fnvUpdate(hash, multi.dims);
                    break;
                }
                case 12: {
                    LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insn;
                    int dfltId = labelIds.computeIfAbsent(lsi.dflt, k -> {
                        int n = labelCounter[0];
                        labelCounter[0] = n + 1;
                        return n;
                    });
                    hash = MethodNodeHasher.fnvUpdate(hash, dfltId);
                    for (int i = 0; i < lsi.keys.size(); ++i) {
                        hash = MethodNodeHasher.fnvUpdate(hash, (Integer)lsi.keys.get(i));
                        int lid = labelIds.computeIfAbsent((LabelNode)lsi.labels.get(i), k -> {
                            int n = labelCounter[0];
                            labelCounter[0] = n + 1;
                            return n;
                        });
                        hash = MethodNodeHasher.fnvUpdate(hash, lid);
                    }
                    continue block14;
                }
                case 11: {
                    TableSwitchInsnNode tsi = (TableSwitchInsnNode)insn;
                    hash = MethodNodeHasher.fnvUpdate(hash, tsi.min);
                    hash = MethodNodeHasher.fnvUpdate(hash, tsi.max);
                    int defId = labelIds.computeIfAbsent(tsi.dflt, k -> {
                        int n = labelCounter[0];
                        labelCounter[0] = n + 1;
                        return n;
                    });
                    hash = MethodNodeHasher.fnvUpdate(hash, defId);
                    for (LabelNode l : tsi.labels) {
                        int lid = labelIds.computeIfAbsent(l, k -> {
                            int n = labelCounter[0];
                            labelCounter[0] = n + 1;
                            return n;
                        });
                        hash = MethodNodeHasher.fnvUpdate(hash, lid);
                    }
                    break;
                }
            }
        }
        return hash;
    }

    private static int fnvUpdate(int hash, int value) {
        return (hash ^= value) * 16777619;
    }

    private static int fnvUpdate(int hash, String str) {
        byte[] data;
        if (str == null) {
            return hash;
        }
        for (byte b : data = str.getBytes(StandardCharsets.UTF_8)) {
            hash ^= b & 0xFF;
            hash *= 16777619;
        }
        return hash;
    }

    private static int updateLdcConstant(int hash, Object cst) {
        if (cst instanceof ConstantDynamic) {
            ConstantDynamic cd = (ConstantDynamic)cst;
            hash = MethodNodeHasher.fnvUpdate(hash, cd.getName());
            hash = MethodNodeHasher.fnvUpdate(hash, cd.getDescriptor());
            hash = MethodNodeHasher.fnvUpdate(hash, cd.getBootstrapMethod().toString());
            for (int i = 0; i < cd.getBootstrapMethodArgumentCount(); ++i) {
                Object arg = cd.getBootstrapMethodArgument(i);
                hash = MethodNodeHasher.fnvUpdate(hash, String.valueOf(arg));
            }
        } else {
            hash = MethodNodeHasher.fnvUpdate(hash, String.valueOf(cst));
        }
        return hash;
    }

    public static int hash(ClassNode classNode, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            String fullName = method.name + method.desc;
            if (!fullName.equals(methodDesc)) continue;
            return MethodNodeHasher.hash(method);
        }
        throw new IllegalArgumentException("Method with descriptor " + methodDesc + " not found!");
    }
}

