/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;

public class AppliedEnergisticsUnifier
implements RecipeUnifier {
    public static final String DROPS = "drops";
    public static final String TOP = "top";
    public static final String MIDDLE = "middle";
    public static final String BOTTOM = "bottom";
    public static final String AMMO = "ammo";

    @Override
    public void collectUnifier(RecipeUnifierBuilder builder) {
        builder.put("output", this::createOutputDropsReplacement);
        builder.put("ingredients", (json, ctx) -> ctx.createIngredientReplacement((JsonElement)json, TOP, MIDDLE, BOTTOM));
        builder.put(AMMO, (json, ctx) -> ctx.createIngredientReplacement((JsonElement)json));
    }

    @Nullable
    private JsonElement createOutputDropsReplacement(JsonElement json, RecipeContext ctx) {
        JsonElement resultReplacement;
        JsonObject jsonObject;
        if (json instanceof JsonObject && (jsonObject = (JsonObject)json).has(DROPS) && (resultReplacement = ctx.createResultReplacement(jsonObject.get(DROPS), false, "item")) != null) {
            jsonObject.add(DROPS, resultReplacement);
            return jsonObject;
        }
        return null;
    }
}

