/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public class RecipeUnifierBuilderImpl
implements RecipeUnifierBuilder {
    private final Map<String, Entry<?>> consumers = new HashMap();

    @Override
    public void forEachObject(String property, BiFunction<JsonObject, RecipeContext, JsonObject> consumer) {
        BiFunction<JsonArray, RecipeContext, JsonArray> arrayConsumer = (array, ctx) -> {
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj;
                JsonObject result;
                JsonElement element = array.get(i);
                if (!(element instanceof JsonObject) || (result = (JsonObject)consumer.apply(obj = (JsonObject)element, (RecipeContext)ctx)) == null) continue;
                array.set(i, (JsonElement)result);
            }
            return array;
        };
        this.put(property, JsonArray.class, arrayConsumer);
    }

    @Override
    public void put(String property, BiFunction<JsonElement, RecipeContext, JsonElement> consumer) {
        this.consumers.put(property, new Entry<JsonElement>(JsonElement.class, consumer));
    }

    @Override
    public <T extends JsonElement> void put(String property, Class<T> type, BiFunction<T, RecipeContext, T> consumer) {
        this.consumers.put(property, new Entry<T>(type, consumer));
    }

    @Nullable
    public JsonObject unify(JsonObject json, RecipeContext context) {
        JsonObject changedValues = new JsonObject();
        for (Map.Entry e : json.entrySet()) {
            JsonElement currentElement;
            Object transformedElement;
            Entry<?> consumer = this.consumers.get(e.getKey());
            if (consumer == null || (transformedElement = consumer.apply((currentElement = (JsonElement)e.getValue()).deepCopy(), context)) == null || transformedElement.equals(currentElement)) continue;
            changedValues.add((String)e.getKey(), transformedElement);
        }
        if (changedValues.size() == 0) {
            return null;
        }
        JsonObject result = new JsonObject();
        for (Map.Entry entry : json.entrySet()) {
            JsonElement changedValue = changedValues.get((String)entry.getKey());
            if (changedValue != null) {
                result.add((String)entry.getKey(), changedValue);
                continue;
            }
            result.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return result;
    }

    public Collection<String> getKeys() {
        return this.consumers.keySet();
    }

    private record Entry<T extends JsonElement>(Class<T> expectedType, BiFunction<T, RecipeContext, T> func) {
        @Nullable
        T apply(JsonElement json, RecipeContext context) {
            if (this.expectedType.isInstance(json)) {
                return (T)((JsonElement)this.func.apply((JsonElement)this.expectedType.cast(json), context));
            }
            return null;
        }
    }
}

