/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.client.BlockScanner;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WallLanternModelsManager {
    private static final Map<Block, ResourceLocation> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<Block, ResourceLocation>();
    private static final Map<Block, ResourceLocation> SPECIAL_LANTERN_MODELS = new IdentityHashMap<Block, ResourceLocation>();

    public static void refreshModels(ResourceManager manager) {
        WallLanternModelsManager.reloadTextures(manager);
        WallLanternModelsManager.reloadModels(manager);
    }

    private static void reloadModels(ResourceManager manager) {
        SPECIAL_LANTERN_MODELS.clear();
        for (Block l : BlockScanner.getInstance().getLanterns()) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("amendments") ? "" : reg.m_135827_() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.m_135815_();
            ResourceLocation fullPath = Amendments.res("models/" + s + ".json");
            Optional resource = manager.m_213713_(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, Amendments.res(s));
        }
    }

    private static void reloadTextures(ResourceManager manager) {
        SPECIAL_MOUNT_TEXTURES.clear();
        for (Block l : BlockScanner.getInstance().getLanterns()) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("amendments") ? "" : reg.m_135827_() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.m_135815_() + ".json";
            ResourceLocation fullPath = Amendments.res(s);
            Optional resource = manager.m_213713_(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((Resource)resource.get()).m_215507_();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, new ResourceLocation(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static TextureAtlasSprite getTexture(Block block) {
        ResourceLocation res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }

    public static BakedModel getModel(BlockModelShaper blockModelShaper, BlockState lantern) {
        ResourceLocation special = SPECIAL_LANTERN_MODELS.get(lantern.m_60734_());
        if (special != null) {
            return ClientHelper.getModel((ModelManager)Minecraft.m_91087_().m_91304_(), (ResourceLocation)special);
        }
        return blockModelShaper.m_110893_(lantern);
    }
}

