/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.LightDetectorBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LightDetectorBlock
extends AEBaseEntityBlock<LightDetectorBlockEntity> {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final DirectionProperty FACING;
    public static final BooleanProperty ODD;
    public static final BooleanProperty WATERLOGGED;

    public LightDetectorBlock() {
        super(LightDetectorBlock.fixtureProps());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)ODD, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_, ODD, WATERLOGGED});
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (level instanceof Level && ((LightDetectorBlockEntity)this.getBlockEntity(level, pos)).isReady()) {
            return ((Level)level).m_46803_(pos) - 6;
        }
        return 0;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        LightDetectorBlockEntity tld = (LightDetectorBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (tld != null) {
            tld.updateLight();
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    private void dropTorch(Level level, BlockPos pos) {
        BlockState prev = level.m_8055_(pos);
        level.m_46961_(pos, true);
        level.m_7260_(pos, prev, level.m_8055_(pos), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(facing.m_122424_());
        return LightDetectorBlock.m_49863_((LevelReader)level, (BlockPos)blockPos, (Direction)facing);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState state = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(pos);
        boolean oddPlacement = (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 != 0;
        state = (BlockState)((BlockState)state.m_61124_((Property)ODD, (Comparable)Boolean.valueOf(oddPlacement))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Level levelReader = context.m_43725_();
        for (Direction direction : adirection = context.m_6232_()) {
            BlockState placedState = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!this.m_7898_(placedState, (LevelReader)levelReader, pos)) continue;
            return placedState;
        }
        return null;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    static {
        for (Direction facing : Direction.values()) {
            double xOff = -0.3 * (double)facing.m_122429_();
            double yOff = -0.3 * (double)facing.m_122430_();
            double zOff = -0.3 * (double)facing.m_122431_();
            VoxelShape shape = Shapes.m_166049_((double)(xOff + 0.3), (double)(yOff + 0.3), (double)(zOff + 0.3), (double)(xOff + 0.7), (double)(yOff + 0.7), (double)(zOff + 0.7));
            SHAPES.put(facing, shape);
        }
        FACING = BlockStateProperties.f_61372_;
        ODD = BooleanProperty.m_61465_((String)"odd");
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

