/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.items;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class PatternEncodingTermMenu
extends MEStorageMenu
implements IMenuCraftingPacket {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private static final int CRAFTING_GRID_SLOTS = 9;
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SET_STONECUTTING_RECIPE_ID = "setStonecuttingRecipeId";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    public static final MenuType<PatternEncodingTermMenu> TYPE = MenuTypeBuilder.create(PatternEncodingTermMenu::new, IPatternTerminalMenuHost.class).build("patternterm");
    private final PatternEncodingLogic encodingLogic;
    private final FakeSlot[] craftingGridSlots = new FakeSlot[9];
    private final FakeSlot[] processingInputSlots = new FakeSlot[81];
    private final FakeSlot[] processingOutputSlots = new FakeSlot[27];
    private final FakeSlot stonecuttingInputSlot;
    private final FakeSlot smithingTableTemplateSlot;
    private final FakeSlot smithingTableBaseSlot;
    private final FakeSlot smithingTableAdditionSlot;
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private final ConfigInventory encodedInputsInv;
    private final ConfigInventory encodedOutputsInv;
    private CraftingRecipe currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    @GuiSync(value=94)
    @Nullable
    public ResourceLocation stonecuttingRecipeId;
    private final List<StonecutterRecipe> stonecuttingRecipes = new ArrayList<StonecutterRecipe>();
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();

    public PatternEncodingTermMenu(int id, Inventory ip, IPatternTerminalMenuHost host) {
        this(TYPE, id, ip, host, true);
    }

    public PatternEncodingTermMenu(MenuType<?> menuType, int id, Inventory ip, IPatternTerminalMenuHost host, boolean bindInventory) {
        super(menuType, id, ip, host, bindInventory);
        int i;
        this.encodingLogic = host.getLogic();
        this.encodedInputsInv = this.encodingLogic.getEncodedInputInv();
        this.encodedOutputsInv = this.encodingLogic.getEncodedOutputInv();
        ConfigMenuInventory encodedInputs = this.encodedInputsInv.createMenuWrapper();
        ConfigMenuInventory encodedOutputs = this.encodedOutputsInv.createMenuWrapper();
        for (i = 0; i < 9; ++i) {
            FakeSlot slot = new FakeSlot(encodedInputs, i);
            slot.setHideAmount(true);
            this.craftingGridSlots[i] = slot;
            this.addSlot(this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.f_35978_, this.getActionSource(), this.powerSource, host.getInventory(), encodedInputs, this);
        this.addSlot(this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        for (i = 0; i < this.processingInputSlots.length; ++i) {
            this.processingInputSlots[i] = new FakeSlot(encodedInputs, i);
            this.addSlot(this.processingInputSlots[i], SlotSemantics.PROCESSING_INPUTS);
        }
        for (i = 0; i < this.processingOutputSlots.length; ++i) {
            this.processingOutputSlots[i] = new FakeSlot(encodedOutputs, i);
            this.addSlot(this.processingOutputSlots[i], SlotSemantics.PROCESSING_OUTPUTS);
        }
        this.processingOutputSlots[0].setIcon(Icon.BACKGROUND_PRIMARY_OUTPUT);
        this.stonecuttingInputSlot = new FakeSlot(encodedInputs, 0);
        this.addSlot(this.stonecuttingInputSlot, SlotSemantics.STONECUTTING_INPUT);
        this.stonecuttingInputSlot.setHideAmount(true);
        this.smithingTableTemplateSlot = new FakeSlot(encodedInputs, 0);
        this.addSlot(this.smithingTableTemplateSlot, SlotSemantics.SMITHING_TABLE_TEMPLATE);
        this.smithingTableTemplateSlot.setHideAmount(true);
        this.smithingTableBaseSlot = new FakeSlot(encodedInputs, 1);
        this.addSlot(this.smithingTableBaseSlot, SlotSemantics.SMITHING_TABLE_BASE);
        this.smithingTableBaseSlot.setHideAmount(true);
        this.smithingTableAdditionSlot = new FakeSlot(encodedInputs, 2);
        this.addSlot(this.smithingTableAdditionSlot, SlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingTableAdditionSlot.setHideAmount(true);
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, this.encodingLogic.getBlankPatternInv(), 0);
        this.addSlot(this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.encodingLogic.getEncodedPatternInv(), 0);
        this.addSlot(this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, ResourceLocation.class, this.encodingLogic::setStonecuttingRecipeId);
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, this.encodingLogic::setMode);
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, this.encodingLogic::setSubstitution);
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, this.encodingLogic::setFluidSubstitution);
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
        this.updateStonecuttingRecipes();
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        Level level = this.getPlayerInventory().f_35978_.m_9236_();
        TransientCraftingContainer ic = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        boolean invalidIngredients = false;
        for (int x = 0; x < ic.m_6643_(); ++x) {
            ItemStack stack = this.getEncodedCraftingIngredient(x);
            if (stack != null) {
                ic.m_6836_(x, stack);
                continue;
            }
            invalidIngredients = true;
        }
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)ic, level)) {
            this.currentRecipe = invalidIngredients ? null : (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.f_41583_ : this.currentRecipe.m_5874_((Container)ic, level.m_9598_());
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern(encodedPattern, this.getPlayerInventory().f_35978_.m_9236_())) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().length; ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            ItemStack encodeOutput = this.encodedPatternSlot.m_7993_();
            if (!(encodeOutput.m_41619_() || PatternDetailsHelper.isEncodedPattern(encodeOutput) || AEItems.BLANK_PATTERN.isSameAs(encodeOutput))) {
                return;
            }
            if (encodeOutput.m_41619_()) {
                ItemStack blankPattern = this.blankPatternSlot.m_7993_();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.m_41774_(1);
                if (blankPattern.m_41613_() <= 0) {
                    this.blankPatternSlot.m_5852_(ItemStack.f_41583_);
                }
            }
            this.encodedPatternSlot.m_5852_(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        ItemStack encodedPattern = this.encodedPatternSlot.m_7993_();
        if (PatternDetailsHelper.isEncodedPattern(encodedPattern)) {
            this.encodedPatternSlot.m_5852_(AEItems.BLANK_PATTERN.stack(encodedPattern.m_41613_()));
        }
    }

    @Nullable
    private ItemStack encodePattern() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case EncodingMode.CRAFTING -> this.encodeCraftingPattern();
            case EncodingMode.PROCESSING -> this.encodeProcessingPattern();
            case EncodingMode.SMITHING_TABLE -> this.encodeSmithingTablePattern();
            case EncodingMode.STONECUTTING -> this.encodeStonecuttingPattern();
        };
    }

    @Nullable
    private ItemStack encodeCraftingPattern() {
        ItemStack[] ingredients = new ItemStack[9];
        boolean valid = false;
        for (int x = 0; x < ingredients.length; ++x) {
            ingredients[x] = this.getEncodedCraftingIngredient(x);
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].m_41619_()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        ItemStack result = this.getAndUpdateOutput();
        if (result.m_41619_() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern(this.currentRecipe, ingredients, result, this.isSubstitute(), this.isSubstituteFluids());
    }

    @Nullable
    private ItemStack encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.encodedInputsInv.size()];
        boolean valid = false;
        for (int slot = 0; slot < this.encodedInputsInv.size(); ++slot) {
            inputs[slot] = this.encodedInputsInv.getStack(slot);
            if (inputs[slot] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[this.encodedOutputsInv.size()];
        for (int slot = 0; slot < this.encodedOutputsInv.size(); ++slot) {
            outputs[slot] = this.encodedOutputsInv.getStack(slot);
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern(inputs, outputs);
    }

    @Nullable
    private ItemStack encodeSmithingTablePattern() {
        AEItemKey base;
        AEItemKey template;
        AEKey aEKey;
        block5: {
            block4: {
                aEKey = this.encodedInputsInv.getKey(0);
                if (!(aEKey instanceof AEItemKey)) break block4;
                template = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(1);
                if (!(aEKey instanceof AEItemKey)) break block4;
                base = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(2);
                if (aEKey instanceof AEItemKey) break block5;
            }
            return null;
        }
        AEItemKey addition = (AEItemKey)aEKey;
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template.toStack());
        container.m_6836_(1, base.toStack());
        container.m_6836_(2, addition.toStack());
        Level level = this.getPlayer().m_9236_();
        SmithingRecipe recipe = level.m_7465_().m_44015_(RecipeType.f_44113_, (Container)container, level).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of(recipe.m_5874_((Container)container, level.m_9598_()));
        return PatternDetailsHelper.encodeSmithingTablePattern(recipe, template, base, addition, output, this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack encodeStonecuttingPattern() {
        if (this.stonecuttingRecipeId == null) {
            return null;
        }
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (!(aEKey instanceof AEItemKey)) {
            return null;
        }
        AEItemKey input = (AEItemKey)aEKey;
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, input.toStack());
        Level level = this.getPlayer().m_9236_();
        StonecutterRecipe recipe = level.m_7465_().m_220248_(RecipeType.f_44112_, (Container)container, level, this.stonecuttingRecipeId).map(Pair::getSecond).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of(recipe.m_8043_(level.m_9598_()));
        return PatternDetailsHelper.encodeStonecuttingPattern(recipe, input, output, this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack getEncodedCraftingIngredient(int slot) {
        AEKey what = this.encodedInputsInv.getKey(slot);
        if (what == null) {
            return ItemStack.f_41583_;
        }
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            return itemKey.toStack(1);
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.m_41619_()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.isSameAs(output);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (this.isServerSide()) {
            if (this.mode != this.encodingLogic.getMode()) {
                this.setMode(this.encodingLogic.getMode());
            }
            this.substitute = this.encodingLogic.isSubstitution();
            this.substituteFluids = this.encodingLogic.isFluidSubstitution();
            this.stonecuttingRecipeId = this.encodingLogic.getStonecuttingRecipeId();
        }
    }

    @Override
    public void onServerDataSync() {
        super.onServerDataSync();
        for (FakeSlot slot : this.craftingGridSlots) {
            slot.setActive(this.mode == EncodingMode.CRAFTING);
        }
        this.craftOutputSlot.setActive(this.mode == EncodingMode.CRAFTING);
        for (FakeSlot slot : this.processingInputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        for (FakeSlot slot : this.processingOutputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        if (this.currentMode != this.mode) {
            this.encodingLogic.setMode(this.mode);
            this.getAndUpdateOutput();
            this.updateStonecuttingRecipes();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && this.isServerSide()) {
            this.m_38946_();
        }
        if (s == this.craftOutputSlot && this.isClientSide()) {
            this.getAndUpdateOutput();
        }
        if (s == this.stonecuttingInputSlot) {
            this.updateStonecuttingRecipes();
        }
    }

    private void updateStonecuttingRecipes() {
        this.stonecuttingRecipes.clear();
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            Level level = this.getPlayer().m_9236_();
            RecipeManager recipeManager = level.m_7465_();
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.m_6836_(0, itemKey.toStack());
            this.stonecuttingRecipes.addAll(recipeManager.m_44056_(RecipeType.f_44112_, (Container)inventory, level));
        }
        if (this.stonecuttingRecipeId != null && this.stonecuttingRecipes.stream().noneMatch(r -> r.m_6423_().equals((Object)this.stonecuttingRecipeId))) {
            this.stonecuttingRecipeId = null;
        }
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        this.encodedInputsInv.clear();
        this.encodedOutputsInv.clear();
        this.m_38946_();
        this.getAndUpdateOutput();
    }

    @Override
    public InternalInventory getCraftingMatrix() {
        return this.encodedInputsInv.createMenuWrapper().getSubInventory(0, 9);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.mode != mode && mode == EncodingMode.STONECUTTING) {
            this.updateStonecuttingRecipes();
        }
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Nullable
    public ResourceLocation getStonecuttingRecipeId() {
        return this.stonecuttingRecipeId;
    }

    public void setStonecuttingRecipeId(ResourceLocation id) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, id);
        } else {
            this.encodingLogic.setStonecuttingRecipeId(id);
        }
    }

    @Override
    protected ItemStack transferStackToMenu(ItemStack input) {
        if (this.blankPatternSlot.m_5857_(input) && (input = this.blankPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.encodedPatternSlot.m_5857_(input) && (input = this.encodedPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        return super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable Slot slot) {
        return this.isProcessingPatternSlot(slot) && slot.m_6657_();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable Slot slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (FakeSlot processingOutputSlot : this.processingOutputSlots) {
            if (processingOutputSlot != slot) continue;
            return true;
        }
        for (FakeSlot craftingSlot : this.processingInputSlots) {
            if (craftingSlot != slot) continue;
            return true;
        }
        return false;
    }

    public FakeSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public FakeSlot[] getProcessingInputSlots() {
        return this.processingInputSlots;
    }

    public FakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public FakeSlot getSmithingTableTemplateSlot() {
        return this.smithingTableTemplateSlot;
    }

    public FakeSlot getSmithingTableBaseSlot() {
        return this.smithingTableBaseSlot;
    }

    public FakeSlot getSmithingTableAdditionSlot() {
        return this.smithingTableAdditionSlot;
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            ItemStack[] newOutputs = new ItemStack[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = ItemStack.f_41583_;
                if (this.processingOutputSlots[i].m_7993_().m_41619_()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    ItemStack nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].m_7993_();
                    if (nextItem.m_41619_()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].m_5852_(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.m_7993_().m_41619_()).count() > 1L;
    }

    public List<StonecutterRecipe> getStonecuttingRecipes() {
        return this.stonecuttingRecipes;
    }
}

