/*
 * Decompiled with CFR 0.152.
 */
package appeng.mixins;

import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.recipes.transform.TransformCircumstance;
import appeng.recipes.transform.TransformLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    private int ae2_transformTime = 0;
    private int ae2_delay = 0;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack m_32055_();

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    void handleExplosion(DamageSource src, float dmg, CallbackInfoReturnable<Boolean> ci) {
        ItemEntity self;
        if (!this.m_9236_().f_46443_ && src.m_269533_(DamageTypeTags.f_268415_) && !this.m_213877_() && TransformLogic.canTransformInExplosion(self = (ItemEntity)this) && TransformLogic.tryTransform(self, TransformCircumstance::isExplosion)) {
            ci.setReturnValue((Object)false);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    void handleEntityTransform(CallbackInfo ci) {
        boolean isValidFluid;
        if (this.m_213877_()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        if (!TransformLogic.canTransformInAnyFluid(self)) {
            return;
        }
        int j = Mth.m_14107_((double)this.m_20185_());
        int i = Mth.m_14107_((double)((this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0));
        int k = Mth.m_14107_((double)this.m_20189_());
        FluidState state = this.m_9236_().m_6425_(new BlockPos(j, i, k));
        boolean bl = isValidFluid = !state.m_76178_() && TransformLogic.canTransformInFluid(self, state);
        if (this.m_9236_().m_5776_()) {
            if (isValidFluid && this.ae2_delay++ > 30 && AEConfig.instance().isEnableEffects()) {
                AppEng.instance().spawnEffect(EffectType.Lightning, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), null);
                this.ae2_delay = 0;
            }
        } else if (isValidFluid) {
            ++this.ae2_transformTime;
            if (this.ae2_transformTime > 60 && !TransformLogic.tryTransform(self, c -> c.isFluid(state))) {
                this.ae2_transformTime = 0;
            }
        } else {
            this.ae2_transformTime = 0;
        }
    }
}

