/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.parts.IPartCollisionHelper;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BusCollisionHelper
implements IPartCollisionHelper {
    private final List<AABB> boxes;
    private final Direction x;
    private final Direction y;
    private final Direction z;
    private final boolean isVisual;

    public BusCollisionHelper(List<AABB> boxes, Direction x, Direction y, Direction z, boolean visual) {
        this.boxes = boxes;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isVisual = visual;
    }

    public BusCollisionHelper(List<AABB> boxes, @Nullable Direction s, boolean visual) {
        this.boxes = boxes;
        this.isVisual = visual;
        if (s == null) {
            this.x = Direction.EAST;
            this.y = Direction.UP;
            this.z = Direction.SOUTH;
        } else {
            switch (s) {
                case DOWN: {
                    this.x = Direction.EAST;
                    this.y = Direction.NORTH;
                    this.z = Direction.DOWN;
                    break;
                }
                case UP: {
                    this.x = Direction.EAST;
                    this.y = Direction.SOUTH;
                    this.z = Direction.UP;
                    break;
                }
                case EAST: {
                    this.x = Direction.SOUTH;
                    this.y = Direction.UP;
                    this.z = Direction.EAST;
                    break;
                }
                case WEST: {
                    this.x = Direction.NORTH;
                    this.y = Direction.UP;
                    this.z = Direction.WEST;
                    break;
                }
                case NORTH: {
                    this.x = Direction.WEST;
                    this.y = Direction.UP;
                    this.z = Direction.NORTH;
                    break;
                }
                case SOUTH: {
                    this.x = Direction.EAST;
                    this.y = Direction.UP;
                    this.z = Direction.SOUTH;
                    break;
                }
                default: {
                    this.x = Direction.EAST;
                    this.y = Direction.UP;
                    this.z = Direction.SOUTH;
                }
            }
        }
    }

    @Override
    public void addBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double aX = (minX /= 16.0) * (double)this.x.m_122429_() + (minY /= 16.0) * (double)this.y.m_122429_() + (minZ /= 16.0) * (double)this.z.m_122429_();
        double aY = minX * (double)this.x.m_122430_() + minY * (double)this.y.m_122430_() + minZ * (double)this.z.m_122430_();
        double aZ = minX * (double)this.x.m_122431_() + minY * (double)this.y.m_122431_() + minZ * (double)this.z.m_122431_();
        double bX = (maxX /= 16.0) * (double)this.x.m_122429_() + (maxY /= 16.0) * (double)this.y.m_122429_() + (maxZ /= 16.0) * (double)this.z.m_122429_();
        double bY = maxX * (double)this.x.m_122430_() + maxY * (double)this.y.m_122430_() + maxZ * (double)this.z.m_122430_();
        double bZ = maxX * (double)this.x.m_122431_() + maxY * (double)this.y.m_122431_() + maxZ * (double)this.z.m_122431_();
        if (this.x.m_122429_() + this.y.m_122429_() + this.z.m_122429_() < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (this.x.m_122430_() + this.y.m_122430_() + this.z.m_122430_() < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (this.x.m_122431_() + this.y.m_122431_() + this.z.m_122431_() < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        minX = Math.min(aX, bX);
        minY = Math.min(aY, bY);
        minZ = Math.min(aZ, bZ);
        maxX = Math.max(aX, bX);
        maxY = Math.max(aY, bY);
        maxZ = Math.max(aZ, bZ);
        this.boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }

    @Override
    public Direction getWorldX() {
        return this.x;
    }

    @Override
    public Direction getWorldY() {
        return this.y;
    }

    @Override
    public Direction getWorldZ() {
        return this.z;
    }

    @Override
    public boolean isBBCollision() {
        return !this.isVisual;
    }
}

