/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.glyph;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.server.util.MarkType;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.github.jarva.arsadditions.setup.registry.AddonEffectRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonGlyphNames;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectMark
extends AbstractEffect {
    public static EffectMark INSTANCE = new EffectMark();

    public EffectMark() {
        super(ArsAdditions.prefix(AddonGlyphNames.EffectMark), "Mark");
    }

    public String getBookDescription() {
        return "Marks the target and stores the mark in a Reliquary.";
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        CompoundTag data = new CompoundTag();
        BlockPos pos = rayTraceResult.m_82425_();
        data.m_128365_("block_pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        data.m_128359_("block_dimension", world.m_46472_().m_135782_().toString());
        this.saveMark(spellContext, shooter, MarkType.LOCATION, data);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        boolean marked;
        CompoundTag data = new CompoundTag();
        Entity entity = rayTraceResult.m_82443_();
        data.m_128362_("entity_uuid", entity.m_20148_());
        data.m_128359_("entity_type", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
        if (entity.m_8077_()) {
            data.m_128359_("entity_name", Component.Serializer.m_130703_((Component)entity.m_7770_()));
        }
        if ((marked = this.saveMark(spellContext, shooter, MarkType.ENTITY, data)) && entity instanceof Player) {
            Player player = (Player)entity;
            data.m_128359_("entity_name", Component.Serializer.m_130703_((Component)player.m_5446_()));
            player.m_7292_(new MobEffectInstance((MobEffect)AddonEffectRegistry.MARKED_EFFECT.get(), (Integer)ServerConfig.SERVER.reliquary_effect_duration.get() * 20));
        }
    }

    private boolean saveMark(SpellContext context, LivingEntity caster, MarkType type, CompoundTag tag) {
        ItemStack reliquary = UnstableReliquary.getReliquaryFromCaster(context, caster);
        if (reliquary == null) {
            return false;
        }
        CompoundTag itemTag = reliquary.m_41784_();
        itemTag.m_128359_("mark_type", type.name());
        itemTag.m_128365_("mark_data", (Tag)tag);
        return true;
    }

    protected int getDefaultManaCost() {
        return 25;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 1);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

