/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.ritual.RitualChunkLoading;
import com.github.jarva.arsadditions.common.ritual.RitualLocateStructure;
import com.github.jarva.arsadditions.datagen.conditions.ConfigCondition;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class RecipeDatagen
extends com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen
implements IConditionBuilder {
    private final HashMap<ResourceLocation, Integer> STONECUTTER_COUNTER = new HashMap();

    public RecipeDatagen(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.consumer = consumer;
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_chain"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_chain"), (ItemLike)Items.f_42417_);
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_chain"), item -> item.m_246208_("crafting/chains/"));
        this.addStonecutter((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"));
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_magelight_lantern"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_magelight_lantern"), (ItemLike)Items.f_42587_);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_magelight_lantern"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"));
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_magelight_lantern"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_magelight_lantern"), item -> item.m_246208_("crafting/lanterns/"));
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("magelight_lantern"), (ItemLike)Items.f_42416_);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("soul_magelight_lantern"), (ItemLike)Items.f_42049_);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_lantern"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_lantern"), (ItemLike)Items.f_42587_);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"));
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_lantern"), item -> item.m_246208_("crafting/lanterns/"));
        this.addRitualRecipe(RitualChunkLoading.RESOURCE_LOCATION, builder -> builder.m_126209_((ItemLike)BlockRegistry.CASCADING_LOG).m_126209_((ItemLike)Items.f_42686_).m_126209_((ItemLike)ItemsRegistry.SOURCE_GEM).m_126209_((ItemLike)ItemsRegistry.EARTH_ESSENCE), new ConfigCondition("ritual_enabled"));
        this.addButtonRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_button"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addButtonRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_button"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_wall"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("cracked_sourcestone_wall"), (ItemLike)AddonBlockRegistry.getBlock("cracked_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_wall"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("cracked_polished_sourcestone_wall"), (ItemLike)AddonBlockRegistry.getBlock("cracked_polished_sourcestone"), true);
        Block sourcestone = BlockRegistry.getBlock((String)"sourcestone");
        for (String name : AddonBlockNames.DECORATIVE_SOURCESTONES) {
            Block block = AddonBlockRegistry.getBlock(name);
            this.addStonecutter((ItemLike)sourcestone, (ItemLike)block);
            this.shapelessBuilder((ItemLike)sourcestone).m_126209_((ItemLike)block).m_126140_(consumer, this.getRecipeId((ItemLike)block, "crafting/revert/", true).m_266382_("_to_sourcestone"));
        }
        this.addDoorRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_door"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addDoorRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_door"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_trapdoor"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_trapdoor"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("magebloom_carpet"), (ItemLike)BlockRegistry.getBlock((String)"magebloom_block"));
        this.shapedBuilder((ItemLike)AddonItemRegistry.HANDY_HAVERSACK.get()).m_126130_("sgs").m_126130_("mem").m_126130_("mmm").m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('m'), (ItemLike)Items.f_41933_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42584_).m_176498_(consumer);
        this.shapedBuilder((ItemLike)AddonItemRegistry.WAYFINDER.get()).m_126130_(" g ").m_126130_("gag").m_126130_(" g ").m_126127_(Character.valueOf('g'), (ItemLike)Items.f_42417_).m_126127_(Character.valueOf('a'), (ItemLike)Items.f_151049_).m_176498_(consumer);
        this.addRitualRecipe(RitualLocateStructure.RESOURCE_LOCATION, builder -> builder.m_126209_((ItemLike)BlockRegistry.VEXING_LOG).m_126209_((ItemLike)Items.f_42522_).m_206419_(ItemTagProvider.SOURCE_GEM_TAG).m_126209_((ItemLike)AddonItemRegistry.WAYFINDER.get()));
        this.addClearRecipe((ItemLike)AddonItemRegistry.ADVANCED_DOMINION_WAND.get());
        this.addClearRecipe((ItemLike)AddonItemRegistry.HANDY_HAVERSACK.get());
        this.addClearRecipe((ItemLike)AddonItemRegistry.XP_JAR.get());
    }

    public void addClearRecipe(ItemLike item) {
        this.shapelessBuilder(item).m_126209_(item).m_126140_(this.consumer, this.getRecipeId(item, "clear_"));
    }

    public void addRitualRecipe(ResourceLocation id, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> modifier) {
        this.addRitualRecipe(id, modifier, null);
    }

    public void addRitualRecipe(ResourceLocation id, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> modifier, ICondition condition) {
        ShapelessRecipeBuilder ritualBuilder = modifier.apply(this.shapelessBuilder((ItemLike)RitualRegistry.getRitualItemMap().get(id)));
        if (condition != null) {
            ConditionalRecipe.builder().addCondition(condition).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ritualBuilder).m_176498_(arg_0)).generateAdvancement().build(this.consumer, id.m_246208_("ritual/"));
        } else {
            ritualBuilder.m_126140_(this.consumer, id.m_246208_("ritual/"));
        }
    }

    public void addButtonRecipe(ItemLike result, ItemLike material) {
        this.addButtonRecipe(result, material, false);
    }

    public void addButtonRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapelessBuilder(result).m_126209_(material).m_126140_(this.consumer, this.getRecipeId(result, "crafting/buttons/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addTrapdoorRecipe(ItemLike result, ItemLike material) {
        this.addTrapdoorRecipe(result, material, false);
    }

    public void addTrapdoorRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).m_126130_("mm").m_126127_(Character.valueOf('m'), material).m_126140_(this.consumer, this.getRecipeId(result, "crafting/trapdoors/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addDoorRecipe(ItemLike result, ItemLike material) {
        this.addDoorRecipe(result, material, false);
    }

    public void addDoorRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).m_126130_("mm").m_126130_("mm").m_126130_("mm").m_126127_(Character.valueOf('m'), material).m_126140_(this.consumer, this.getRecipeId(result, "crafting/doors/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addWallRecipe(ItemLike result, ItemLike material) {
        this.addWallRecipe(result, material, false);
    }

    public void addWallRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result, 6).m_126130_("   ").m_126130_("mmm").m_126130_("mmm").m_126127_(Character.valueOf('m'), material).m_126140_(this.consumer, RecipeBuilder.m_176493_((ItemLike)result).m_246208_("crafting/walls/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addChainRecipe(ItemLike result, ItemLike material) {
        this.addChainRecipe(result, material, false);
    }

    public void addChainRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).m_126130_("i").m_126130_("m").m_126130_("i").m_126127_(Character.valueOf('i'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('m'), material).m_126140_(this.consumer, this.getRecipeId(result, "crafting/chains/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addMagelightLanternRecipe(ItemLike result, ItemLike material) {
        this.addLanternRecipe(result, material, (ItemLike)ItemsRegistry.SOURCE_GEM);
    }

    public void addLanternRecipe(ItemLike result, ItemLike material) {
        this.addLanternRecipe(result, material, (ItemLike)Items.f_42000_);
    }

    public void addLanternRecipe(ItemLike result, ItemLike material, ItemLike center) {
        this.shapedBuilder(result).m_126130_("imi").m_126130_("msm").m_126130_("imi").m_126127_(Character.valueOf('i'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('m'), material).m_126127_(Character.valueOf('s'), center).m_126140_(this.consumer, this.getRecipeId(result, "crafting/lanterns/"));
    }

    public void addBiDirectionalRecipe(ItemLike a, ItemLike b) {
        this.addBiDirectionalRecipe(a, b, item -> item);
    }

    public void addBiDirectionalRecipe(ItemLike a, ItemLike b, Function<ResourceLocation, ResourceLocation> applicator) {
        this.shapelessBuilder(a).m_126209_(b).m_126140_(this.consumer, applicator.apply(this.getRecipeId(a, "reversed_")));
        this.shapelessBuilder(b).m_126209_(a).m_126140_(this.consumer, applicator.apply(this.getRecipeId(b, "reversed_")));
    }

    public void addStonecutter(ItemLike input, ItemLike output) {
        ResourceLocation location = this.getRecipeId(input, "crafting/stonecutter/", true);
        int counter = this.STONECUTTER_COUNTER.getOrDefault(location, 0);
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output).m_126132_("has_journal", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).m_126140_(this.consumer, location.m_266382_("_" + counter));
        this.STONECUTTER_COUNTER.put(location, counter + 1);
    }

    public ResourceLocation getRecipeId(ItemLike input) {
        return this.getRecipeId(input, "", false);
    }

    public ResourceLocation getRecipeId(ItemLike input, String prefix) {
        return this.getRecipeId(input, prefix, false);
    }

    public ResourceLocation getRecipeId(ItemLike input, String prefix, boolean convert) {
        ResourceLocation loc = RecipeBuilder.m_176493_((ItemLike)input).m_246208_(prefix);
        return convert ? ArsAdditions.prefix(loc.m_135815_()) : loc;
    }
}

