/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.util;

import brightspark.asynclocator.AsyncLocator;
import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.loot.functions.ExplorationScrollFunction;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class LocateUtil {
    private static final Cache<UUID, LocateState> STRUCTURE_LOOKUP_CACHE = CacheBuilder.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(5L)).build();
    public static final String STRUCTURE_LOOKUP_KEY = "async-lookup.uuid";

    public static HolderSet<Structure> holderFromTag(ServerLevel level, TagKey<Structure> structureTagKey) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        return (HolderSet)registry.m_203431_(structureTagKey).orElseThrow();
    }

    public static HolderSet<Structure> holderFromResource(ServerLevel level, ResourceKey<Structure> structureResourceKey) {
        Registry registry = level.m_9598_().m_175515_(Registries.f_256944_);
        return (HolderSet)registry.m_203636_(structureResourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).orElseThrow();
    }

    public static void resolveUUID(ServerLevel level, Vec3 position, ItemStack stack, @Nullable Entity entity) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(STRUCTURE_LOOKUP_KEY)) {
            return;
        }
        UUID uuid = tag.m_128342_(STRUCTURE_LOOKUP_KEY);
        LocateState state = (LocateState)STRUCTURE_LOOKUP_CACHE.getIfPresent((Object)uuid);
        if (state == null) {
            ArsAdditions.LOGGER.warn("Found Exploration Warp Scroll with no pending structure lookup.");
            LocateUtil.locateFromStack(level, position, stack);
        }
        if (state == null || state.status() == Status.PENDING) {
            return;
        }
        stack.m_41749_(STRUCTURE_LOOKUP_KEY);
        if (state.status() == Status.FAILURE) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.failed"));
            STRUCTURE_LOOKUP_CACHE.invalidate((Object)uuid);
        } else {
            LocateUtil.setScrollData(level, stack, state.pos());
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.m_237115_((String)"tooltip.ars_additions.exploration_warp_scroll.located"));
        }
    }

    public static boolean isPending(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(STRUCTURE_LOOKUP_KEY);
    }

    public static void locateWithState(ItemStack itemStack, ServerLevel level, HolderSet<Structure> holderSet, BlockPos origin, int searchRadius, boolean skipKnownStructures) {
        UUID uuid = UUID.randomUUID();
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(STRUCTURE_LOOKUP_KEY)) {
            uuid = itemStack.m_41783_().m_128342_(STRUCTURE_LOOKUP_KEY);
        } else {
            itemStack.m_41784_().m_128362_(STRUCTURE_LOOKUP_KEY, uuid);
        }
        STRUCTURE_LOOKUP_CACHE.put((Object)uuid, (Object)LocateState.pending());
        UUID finalUuid = uuid;
        LocateUtil.locate(level, holderSet, origin, searchRadius, skipKnownStructures, pair -> {
            if (pair == null) {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.failure());
                return;
            }
            BlockPos pos = (BlockPos)pair.getFirst();
            if (pos == null) {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.failure());
            } else {
                STRUCTURE_LOOKUP_CACHE.put((Object)finalUuid, (Object)LocateState.success((Structure)((Holder)pair.getSecond()).m_203334_(), pos));
            }
        });
    }

    public static void locateFromStack(ServerLevel level, Vec3 position, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        HolderSet<Structure> holderSet = LocateUtil.holderFromTag(level, ExplorationScrollFunction.DEFAULT_DESTINATION);
        Vec3 origin = position;
        int searchRadius = 50;
        boolean skipKnown = true;
        if (tag != null) {
            ResourceKey key;
            if (tag.m_128441_("resource")) {
                key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(tag.m_128461_("resource")));
                holderSet = LocateUtil.holderFromResource(level, (ResourceKey<Structure>)key);
            }
            if (tag.m_128441_("tag")) {
                key = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(tag.m_128461_("tag")));
                holderSet = LocateUtil.holderFromTag(level, (TagKey<Structure>)key);
            }
            if (tag.m_128441_("origin")) {
                CompoundTag originTag = tag.m_128469_("origin");
                double x = originTag.m_128459_("x");
                double y = originTag.m_128459_("y");
                double z = originTag.m_128459_("z");
                origin = new Vec3(x, y, z);
            }
            if (tag.m_128441_("search_radius")) {
                searchRadius = tag.m_128451_("search_radius");
            }
            if (tag.m_128441_("skip_known")) {
                skipKnown = tag.m_128471_("skip_known");
            }
        }
        LocateUtil.locateWithState(stack, level, holderSet, BlockPos.m_274446_((Position)origin), searchRadius, skipKnown);
    }

    public static void locate(ServerLevel level, HolderSet<Structure> holderSet, BlockPos origin, int searchRadius, boolean skipKnownStructures, Consumer<Pair<BlockPos, Holder<Structure>>> consumer) {
        if (ModList.get().isLoaded("asynclocator")) {
            AsyncLocator.locate((ServerLevel)level, holderSet, (BlockPos)origin, (int)searchRadius, (boolean)skipKnownStructures).then(pair -> {
                if (pair == null) {
                    level.m_7654_().m_18707_(() -> consumer.accept(null));
                    return;
                }
                Pair modified = pair.mapFirst(pos -> LocateUtil.findBlockPos(level, (Structure)((Holder)pair.getSecond()).get(), pos));
                level.m_7654_().m_18707_(() -> consumer.accept(modified));
            });
        } else {
            ArsAdditions.LOGGER.warn("Running locate on server thread. If this causes lag please install Async Locator https://modrinth.com/mod/async-locator");
            Pair pair2 = level.m_7726_().m_8481_().m_223037_(level, holderSet, origin, searchRadius, skipKnownStructures);
            if (pair2 == null) {
                consumer.accept(null);
                return;
            }
            Pair modified = pair2.mapFirst(pos -> LocateUtil.findBlockPos(level, (Structure)((Holder)pair2.getSecond()).get(), pos));
            consumer.accept((Pair<BlockPos, Holder<Structure>>)modified);
        }
    }

    public static WarpScroll.WarpScrollData setScrollData(ServerLevel level, ItemStack stack, BlockPos pos) {
        StableWarpScroll.StableScrollData data = new StableWarpScroll.StableScrollData(stack);
        data.setData(pos, level.m_46472_().m_135782_().toString(), Vec2.f_82462_);
        return data;
    }

    public static BlockPos findBlockPos(ServerLevel level, Structure structure, BlockPos pos) {
        StructureStart structureStart = level.m_215010_().m_220512_(SectionPos.m_123199_((BlockPos)pos), structure, (StructureAccess)level.m_46865_(pos));
        if (structureStart == null) {
            BlockPos highest = LocateUtil.findHighestSafeBlock(level, pos);
            if (highest == null) {
                return pos.m_175288_(level.m_5736_());
            }
            return highest;
        }
        BoundingBox box = structureStart.m_73601_();
        for (int i = 0; i < 5; ++i) {
            int x = Mth.m_216287_((RandomSource)level.f_46441_, (int)box.m_162395_(), (int)box.m_162399_());
            int y = Mth.m_216287_((RandomSource)level.f_46441_, (int)box.m_162396_(), (int)box.m_162400_());
            int z = Mth.m_216287_((RandomSource)level.f_46441_, (int)box.m_162398_(), (int)box.m_162401_());
            BlockPos start = new BlockPos(x, y, z);
            for (BlockPos.MutableBlockPos position : BlockPos.m_121935_((BlockPos)start, (int)10, (Direction)Direction.NORTH, (Direction)Direction.EAST)) {
                BlockPos highest = LocateUtil.findHighestSafeBlock(level, (BlockPos)position, y, box.m_162396_());
                if (highest == null) continue;
                return highest;
            }
        }
        return LocateUtil.findHighestSafeBlock(level, pos);
    }

    public static BlockPos findHighestSafeBlock(ServerLevel level, BlockPos pos) {
        return LocateUtil.findHighestSafeBlock(level, pos, level.m_151558_(), level.m_141937_());
    }

    public static BlockPos findHighestSafeBlock(ServerLevel level, BlockPos pos, int max, int min) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_().m_142448_(max);
        boolean headAir = level.m_8055_((BlockPos)mutable).m_60795_();
        mutable.m_122173_(Direction.DOWN);
        boolean feetAir = level.m_8055_((BlockPos)mutable).m_60795_();
        while (mutable.m_123342_() > min) {
            mutable.m_122173_(Direction.DOWN);
            boolean groundAir = level.m_8055_((BlockPos)mutable).m_60795_();
            if (!groundAir && feetAir && headAir) {
                return mutable.m_122173_(Direction.UP);
            }
            headAir = feetAir;
            feetAir = groundAir;
        }
        return null;
    }

    public record LocateState(Status status, Structure structure, BlockPos pos) {
        public static LocateState pending() {
            return new LocateState(Status.PENDING, null, null);
        }

        public static LocateState failure() {
            return new LocateState(Status.FAILURE, null, null);
        }

        public static LocateState success(Structure structure, BlockPos pos) {
            return new LocateState(Status.SUCCESS, structure, pos);
        }
    }

    public static enum Status {
        PENDING,
        SUCCESS,
        FAILURE;

    }
}

