/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.familiars;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FirenandoFamiliar
extends FamiliarEntity
implements ISpellCastListener,
IVariantColorProvider<FamiliarEntity> {
    public static List<AbstractSpellPart> projectileGlyphs = new ArrayList<AbstractSpellPart>();

    public FirenandoFamiliar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public FirenandoFamiliar(Level world) {
        super((EntityType)ModEntities.FIRENANDO_FAMILIAR.get(), world);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        super.registerControllers(data);
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 0, this::idlePredicate)});
    }

    public void onModifier(SpellModifierEvent event) {
        if (this.m_6084_() && this.getOwner() != null && this.getOwner().equals((Object)event.caster) && SpellSchools.ELEMENTAL_FIRE.isPartOfSchool(event.spellPart)) {
            event.builder.addDamageModifier(2.0);
        }
    }

    public void onCostCalc(SpellCostCalcEvent event) {
        if (this.m_6084_() && this.getOwner() != null && this.getOwner().equals((Object)event.context.getUnwrappedCaster()) && projectileGlyphs.contains(event.context.getSpell().recipe.get(0))) {
            event.currentCost = (int)((double)event.currentCost - (double)event.context.getSpell().getCost() * 0.5);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && player.equals((Object)this.getOwner())) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == Items.f_42542_) {
                stack.m_41774_(1);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1200));
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() == Blocks.f_50450_.m_5456_() && !this.getColor().equals(FirenandoEntity.Variants.MAGMA.toString())) {
                this.setColor(FirenandoEntity.Variants.MAGMA.toString());
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() == Blocks.f_50135_.m_5456_() && !this.getColor().equals(FirenandoEntity.Variants.SOUL.toString())) {
                this.setColor(FirenandoEntity.Variants.SOUL.toString());
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135381_(COLOR, (Object)FirenandoEntity.Variants.MAGMA.toString());
    }

    public PlayState walkPredicate(AnimationState event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
    }

    public PlayState idlePredicate(AnimationState<FirenandoFamiliar> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("idle.body"));
    }

    public void setColor(String color, FamiliarEntity object) {
        super.setColor(color);
    }

    public String getColor(FamiliarEntity firenandoFamiliar) {
        return (String)this.f_19804_.m_135370_(COLOR);
    }

    public ResourceLocation getTexture(FamiliarEntity entity) {
        return ArsElemental.prefix("textures/entity/firenando_" + (this.getColor().isEmpty() ? FirenandoEntity.Variants.MAGMA.toString() : this.getColor()) + ".png");
    }
}

