/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe.jei;

import alexthw.ars_elemental.recipe.ElementalArmorRecipe;
import alexthw.ars_elemental.recipe.NetheriteUpgradeRecipe;
import alexthw.ars_elemental.recipe.jei.ElementalUpgradeRecipeCategory;
import alexthw.ars_elemental.recipe.jei.SpellBookUpgradeRecipeCategory;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiArsExtraPlugin
implements IModPlugin {
    public static final RecipeType<ElementalArmorRecipe> ELEMENTAL_ARMOR_TYPE = RecipeType.create((String)"ars_elemental", (String)"armor_upgrade", ElementalArmorRecipe.class);
    public static final RecipeType<NetheriteUpgradeRecipe> SPELLBOOK_NETHERITE_TYPE = RecipeType.create((String)"ars_elemental", (String)"netherite_upgrade", NetheriteUpgradeRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ars_elemental", "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ElementalUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new SpellBookUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        ArrayList<ElementalArmorRecipe> armorRecipes = new ArrayList<ElementalArmorRecipe>();
        ArrayList<NetheriteUpgradeRecipe> spellbook = new ArrayList<NetheriteUpgradeRecipe>();
        for (Recipe i : manager.m_44051_()) {
            if (i instanceof ElementalArmorRecipe) {
                ElementalArmorRecipe aer = (ElementalArmorRecipe)i;
                armorRecipes.add(aer);
                continue;
            }
            if (!(i instanceof NetheriteUpgradeRecipe)) continue;
            NetheriteUpgradeRecipe nur = (NetheriteUpgradeRecipe)i;
            spellbook.add(nur);
        }
        registry.addRecipes(ELEMENTAL_ARMOR_TYPE, armorRecipes);
        registry.addRecipes(SPELLBOOK_NETHERITE_TYPE, spellbook);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ELEMENTAL_ARMOR_TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{SPELLBOOK_NETHERITE_TYPE});
    }
}

