/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.setup.registry.MenuRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler<C extends AbstractContainerMenu>
implements IRecipeTransferHandler<C, CraftingRecipe> {
    private final Class<C> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    private static final List<Class<? extends AbstractContainerMenu>> containerClasses = new ArrayList<Class<? extends AbstractContainerMenu>>();
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }
    };

    public CraftingTerminalTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    private int findMatchingItem(Inventory inventory, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        boolean emptyTag = tag != null && tag.m_128456_();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            ItemStack item = (ItemStack)inventory.f_35974_.get(i);
            if (item.m_41619_()) continue;
            if (emptyTag && ItemStack.m_41656_((ItemStack)stack, (ItemStack)item)) {
                return i;
            }
            if (emptyTag || !ItemStack.m_150942_((ItemStack)item, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(AbstractContainerMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IAutoFillTerminal) {
            IAutoFillTerminal term = (IAutoFillTerminal)container;
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList<ItemStack[]> inputs = new ArrayList<ItemStack[]>();
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                ItemStack[] possibleStacks = (ItemStack[])view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toArray(ItemStack[]::new);
                if (possibleStacks.length == 0) {
                    inputs.add(null);
                    continue;
                }
                inputs.add(possibleStacks);
                boolean found = false;
                for (ItemStack stack : possibleStacks) {
                    if (stack == null || this.findMatchingItem(player.m_150109_(), stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ItemStack stack : possibleStacks) {
                        StoredItemStack s = new StoredItemStack(stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer) {
                ItemStack[][] stacks = (ItemStack[][])inputs.toArray((T[])new ItemStack[0][]);
                CompoundTag compound = new CompoundTag();
                ListTag list = new ListTag();
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i] == null) continue;
                    CompoundTag CompoundNBT = new CompoundTag();
                    CompoundNBT.m_128344_("s", (byte)i);
                    int k = 0;
                    for (int j = 0; j < stacks[i].length && k < 9; ++j) {
                        StoredItemStack s;
                        if (stacks[i][j] == null || stacks[i][j].m_41619_() || !stored.contains(s = new StoredItemStack(stacks[i][j])) && this.findMatchingItem(player.m_150109_(), stacks[i][j]) == -1) continue;
                        CompoundTag tag = new CompoundTag();
                        stacks[i][j].m_41739_(tag);
                        CompoundNBT.m_128365_("i" + k++, (Tag)tag);
                    }
                    CompoundNBT.m_128344_("l", (byte)Math.min(9, k));
                    list.add((Object)CompoundNBT);
                }
                compound.m_128365_("i", (Tag)list);
                term.sendMessage(compound);
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.helper.createUserErrorForMissingSlots((Component)Component.m_237115_((String)"tooltip.ars_nouveau.items_missing"), missing));
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (Class<? extends AbstractContainerMenu> aClass : containerClasses) {
            recipeTransferRegistry.addRecipeTransferHandler(new CraftingTerminalTransferHandler<AbstractContainerMenu>(aClass, recipeTransferRegistry.getTransferHelper()), RecipeTypes.CRAFTING);
        }
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.of((MenuType)MenuRegistry.STORAGE.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    static {
        containerClasses.add(CraftingTerminalMenu.class);
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(GuiGraphics matrixStack, int mouseX, int mouseY, IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
            this.parent.showError(matrixStack, mouseX, mouseY, recipeLayout, recipeX, recipeY);
        }
    }
}

