/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionSyncPacket {
    public int entity;
    public int duration;
    public ResourceLocation effect;

    public PotionSyncPacket(int entity, ResourceLocation effect, int duration) {
        this.entity = entity;
        this.effect = effect;
        this.duration = duration;
    }

    public PotionSyncPacket(int entity, MobEffect effect, int duration) {
        this.entity = entity;
        this.effect = PotionSyncPacket.getRegistryName(effect);
        this.duration = duration;
    }

    public void toBytes(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.entity);
        friendlyByteBuf.m_130085_(this.effect);
        friendlyByteBuf.writeInt(this.duration);
    }

    public PotionSyncPacket(FriendlyByteBuf friendlyByteBuf) {
        this.entity = friendlyByteBuf.readInt();
        this.effect = friendlyByteBuf.m_130281_();
        this.duration = friendlyByteBuf.readInt();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        if (contextSupplier.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        contextSupplier.get().enqueueWork(() -> {
            LivingEntity living;
            Entity patt1950$temp;
            Minecraft mc = ArsNouveau.proxy.getMinecraft();
            if (mc != null && mc.f_91073_ != null && (patt1950$temp = mc.f_91073_.m_6815_(this.entity)) instanceof LivingEntity && (living = (LivingEntity)patt1950$temp) != ArsNouveau.proxy.getPlayer()) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effect);
                if (effect == null) {
                    return;
                }
                if (this.duration > 0) {
                    living.m_7292_(new MobEffectInstance(effect, this.duration, 0, false, false, false));
                } else {
                    living.m_21195_(effect);
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
    }
}

