/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class AzBlockEntityModelRenderer<T extends BlockEntity>
extends AzModelRenderer<T> {
    protected final AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline;

    public AzBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
        this.blockEntityRendererPipeline = blockEntityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        BlockEntity entity = (BlockEntity)context.animatable();
        PoseStack poseStack = context.poseStack();
        if (!isReRender) {
            poseStack.m_85837_(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(entity), poseStack);
            AzBlockAnimator<T> animator = this.blockEntityRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, entity, context.partialTick());
            }
        }
        this.blockEntityRendererPipeline.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        ResourceLocation textureLocation = this.blockEntityRendererPipeline.config().textureLocation(entity);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        VertexConsumer buffer = context.vertexConsumer();
        MultiBufferSource bufferSource = context.multiBufferSource();
        BlockEntity entity = (BlockEntity)context.animatable();
        PoseStack poseStack = context.poseStack();
        RenderType renderType = context.renderType();
        poseStack.m_85836_();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, Vec3.f_82478_.m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)entity.m_58899_().m_123341_(), (float)entity.m_58899_().m_123342_(), (float)entity.m_58899_().m_123343_())));
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && buffer instanceof BufferBuilder) {
            BufferBuilder builder = (BufferBuilder)buffer;
            if (!builder.f_85661_) {
                context.setVertexConsumer(bufferSource.m_6299_(renderType));
            }
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.m_85849_();
    }

    protected Direction getFacing(T block) {
        BlockState blockState = block.m_58900_();
        if (blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (blockState.m_61138_((Property)DirectionalBlock.f_52588_)) {
            return (Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_);
        }
        return Direction.NORTH;
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            }
        }
    }
}

