/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorLayer<T extends LivingEntity>
implements AzRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();
    protected static final HumanoidModel<LivingEntity> INNER_ARMOR_MODEL = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
    protected static final HumanoidModel<LivingEntity> OUTER_ARMOR_MODEL = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171165_));
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
        this.mainHandStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.MAINHAND);
        this.offhandStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.OFFHAND);
        this.helmetStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.HEAD);
        this.chestplateStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.CHEST);
        this.leggingsStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.LEGS);
        this.bootsStack = ((LivingEntity)context.animatable()).m_6844_(EquipmentSlot.FEET);
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(context, bone);
        if (armorStack == null) {
            return;
        }
        Item item = armorStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(context, bone, armorStack, skullBlock);
        } else {
            this.renderArmor(context, bone, armorStack);
        }
    }

    public void renderArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack armorStack) {
        EquipmentSlot slot = this.getEquipmentSlotForBone(context, bone, armorStack);
        AzArmorRenderer renderer = AzArmorRendererRegistry.getOrNull(armorStack.m_41720_());
        HumanoidModel<T> model = this.getModelForItem(armorStack, slot);
        ModelPart modelPart = this.getModelPartForBone(context, bone, model);
        if (!modelPart.f_104212_.isEmpty()) {
            context.poseStack().m_85836_();
            context.poseStack().m_85841_(-1.0f, -1.0f, 1.0f);
            if (renderer != null) {
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderAzArmorPiece(context, slot, armorStack, renderer, (LivingEntity)context.animatable(), model, modelPart);
            } else if (armorStack.m_41720_() instanceof ArmorItem) {
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderVanillaArmorPiece(context, bone, slot, armorStack, modelPart);
            }
            context.poseStack().m_85849_();
        }
    }

    @NotNull
    protected EquipmentSlot getEquipmentSlotForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack) {
        LivingEntity animatable = (LivingEntity)context.animatable();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean isHumanoidArmorSlotType;
            boolean bl = isHumanoidArmorSlotType = slot.m_20743_() == EquipmentSlot.Type.ARMOR;
            if (!isHumanoidArmorSlotType || stack != animatable.m_6844_(slot)) continue;
            return slot;
        }
        return EquipmentSlot.CHEST;
    }

    @NotNull
    protected ModelPart getModelPartForBone(AzRendererPipelineContext<T> context, AzBone bone, HumanoidModel<?> baseModel) {
        return baseModel.f_102810_;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        return null;
    }

    protected void renderAzArmorPiece(AzRendererPipelineContext<T> context, EquipmentSlot slot, ItemStack armorStack, AzArmorRenderer renderer, LivingEntity entity, HumanoidModel<T> model, ModelPart modelPart) {
        AzArmorRendererPipeline renderPipelines = renderer.rendererPipeline();
        AzArmorBoneContext boneContext = renderPipelines.context().boneContext();
        AzArmorModel<?> armorModel = renderPipelines.armorModel();
        renderer.prepForRender((Entity)entity, armorStack, slot, model);
        boneContext.applyBoneVisibilityByPart(slot, modelPart, model);
        armorModel.m_7695_(context.poseStack(), null, context.packedLight(), OverlayTexture.f_118083_, context.red(), context.green(), context.blue(), context.alpha());
    }

    protected <I extends Item> void renderVanillaArmorPiece(AzRendererPipelineContext<T> context, AzBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart) {
        VertexConsumer buffer = this.getVanillaArmorBuffer(context, armorStack, slot, bone, false);
        modelPart.m_104301_(context.poseStack(), buffer, context.packedLight(), context.packedOverlay());
        if (armorStack.m_41790_()) {
            modelPart.m_104306_(context.poseStack(), this.getVanillaArmorBuffer(context, armorStack, slot, bone, true), context.packedLight(), context.packedOverlay(), context.red(), context.green(), context.blue(), context.alpha());
        }
    }

    protected VertexConsumer getVanillaArmorBuffer(AzRendererPipelineContext<T> context, ItemStack stack, EquipmentSlot slot, AzBone bone, boolean forGlint) {
        if (forGlint) {
            return context.multiBufferSource().m_6299_(RenderType.m_110484_());
        }
        return context.multiBufferSource().m_6299_(RenderType.m_110431_((ResourceLocation)this.getVanillaArmorResource((Entity)context.animatable(), stack, slot, bone.getName())));
    }

    @Nullable
    protected AzArmorRenderer getRendererForItem(ItemStack stack) {
        Item item = stack.m_41720_();
        return AzArmorRendererRegistry.getOrNull(item);
    }

    protected HumanoidModel<T> getModelForItem(ItemStack stack, EquipmentSlot slot) {
        AzArmorRenderer renderer = this.getRendererForItem(stack);
        if (renderer == null) {
            return slot == EquipmentSlot.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        }
        return renderer.rendererPipeline().armorModel();
    }

    protected void renderSkullAsArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack, AbstractSkullBlock skullBlock) {
        GameProfile skullProfile = null;
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            StringTag tag;
            String skullOwner;
            Tag skullTag = stackTag.m_128423_("SkullOwner");
            if (skullTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)skullTag;
                skullProfile = NbtUtils.m_129228_((CompoundTag)compoundTag);
            } else if (skullTag instanceof StringTag && !(skullOwner = (tag = (StringTag)skullTag).m_7916_()).isBlank()) {
                CompoundTag profileTag = new CompoundTag();
                SkullBlockEntity.m_155738_((GameProfile)new GameProfile(null, skullOwner), name -> stackTag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)profileTag, (GameProfile)name)));
                skullProfile = NbtUtils.m_129228_((CompoundTag)profileTag);
            }
        }
        SkullBlock.Type type = skullBlock.m_48754_();
        SkullModelBase model = (SkullModelBase)SkullBlockRenderer.m_173661_((EntityModelSet)Minecraft.m_91087_().m_167973_()).get(type);
        RenderType renderType = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)skullProfile);
        context.poseStack().m_85836_();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        context.poseStack().m_85841_(1.1875f, 1.1875f, 1.1875f);
        context.poseStack().m_252880_(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.m_173663_(null, (float)0.0f, (float)0.0f, (PoseStack)context.poseStack(), (MultiBufferSource)context.multiBufferSource(), (int)context.packedLight(), (SkullModelBase)model, (RenderType)renderType);
        context.poseStack().m_85849_();
    }

    protected void prepModelPartForRender(AzRendererPipelineContext<T> context, AzBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().get(0);
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.f_104212_.get(0);
        double armorBoneSizeX = firstCube.size().m_7096_();
        double armorBoneSizeY = firstCube.size().m_7098_();
        double armorBoneSizeZ = firstCube.size().m_7094_();
        float actualArmorSizeX = Math.abs(armorCube.f_104338_ - armorCube.f_104335_);
        float actualArmorSizeY = Math.abs(armorCube.f_104339_ - armorCube.f_104336_);
        float actualArmorSizeZ = Math.abs(armorCube.f_104340_ - armorCube.f_104337_);
        float scaleX = (float)(armorBoneSizeX / (double)actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / (double)actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / (double)actualArmorSizeZ);
        sourcePart.m_104227_(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.f_104203_ = -bone.getRotX();
        sourcePart.f_104204_ = -bone.getRotY();
        sourcePart.f_104205_ = bone.getRotZ();
        context.poseStack().m_85841_(scaleX, scaleY, scaleZ);
    }

    public ResourceLocation getVanillaArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, String type) {
        String domain = "minecraft";
        String path = ((ArmorItem)stack.m_41720_()).m_40401_().m_6082_();
        String[] materialNameSplit = path.split(":", 2);
        if (materialNameSplit.length > 1) {
            domain = materialNameSplit[0];
            path = materialNameSplit[1];
        }
        if (!((String)type).isBlank()) {
            type = "_" + (String)type;
        }
        String texture = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, path, slot == EquipmentSlot.LEGS ? 2 : 1, type);
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::new);
    }
}

