/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.BiConsumer;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.core.object.DataTicket;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.platform.Services;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayersContainer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Deprecated(forRemoval=true)
public class GeoArmorRenderer<T extends Item>
extends HumanoidModel
implements GeoRenderer<T> {
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected HumanoidModel<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    public BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;
    protected GeoBone rightBoot = null;
    protected GeoBone leftBoot = null;
    protected Entity currentEntity = null;
    protected ItemStack currentStack = null;
    protected EquipmentSlot currentSlot = null;

    public GeoArmorRenderer(GeoModel<T> model) {
        super(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        this.model = model;
        this.f_102610_ = false;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public Entity getCurrentEntity() {
        return this.currentEntity;
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public EquipmentSlot getCurrentSlot() {
        return this.currentSlot;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentStack) + (long)this.currentEntity.m_19879_();
    }

    @Override
    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110431_((ResourceLocation)texture);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Nullable
    public GeoBone getHeadBone() {
        return this.model.getBone("armorHead").orElse(null);
    }

    @Nullable
    public GeoBone getBodyBone() {
        return this.model.getBone("armorBody").orElse(null);
    }

    @Nullable
    public GeoBone getRightArmBone() {
        return this.model.getBone("armorRightArm").orElse(null);
    }

    @Nullable
    public GeoBone getLeftArmBone() {
        return this.model.getBone("armorLeftArm").orElse(null);
    }

    @Nullable
    public GeoBone getRightLegBone() {
        return this.model.getBone("armorRightLeg").orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegBone() {
        return this.model.getBone("armorLeftLeg").orElse(null);
    }

    @Nullable
    public GeoBone getRightBootBone() {
        return this.model.getBone("armorRightBoot").orElse(null);
    }

    @Nullable
    public GeoBone getLeftBootBone() {
        return this.model.getBone("armorLeftBoot").orElse(null);
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(this.animatable)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForBaby(poseStack, animatable, partialTick, isReRender);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!(this.currentEntity instanceof GeoAnimatable)) {
            this.applyBoneVisibilityBySlot(this.currentSlot);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().f_91060_.f_109464_.m_110104_();
        if (Minecraft.m_91087_().f_91060_.m_109817_() && mc.m_91314_(this.currentEntity)) {
            bufferSource = Minecraft.m_91087_().f_91060_.f_109464_.m_110109_();
        }
        float partialTick = mc.m_91296_();
        RenderType renderType = this.getRenderType(this.animatable, this.getTextureLocation((GeoAnimatable)this.animatable), (MultiBufferSource)bufferSource, partialTick);
        buffer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)this.currentStack.m_41790_());
        this.defaultRender(poseStack, (GeoAnimatable)this.animatable, (MultiBufferSource)bufferSource, null, buffer, 0.0f, partialTick, packedLight);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        if (!isReRender) {
            AnimationState<T> animationState = new AnimationState<T>(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoItem)animatable).getTick(this.currentEntity));
            animationState.setData(DataTickets.ITEMSTACK, this.currentStack);
            animationState.setData(DataTickets.ENTITY, this.currentEntity);
            animationState.setData(DataTickets.EQUIPMENT_SLOT, this.currentSlot);
            this.model.addAdditionalStateData((Item)animatable, instanceId, (BiConsumer<DataTicket<Item>, Item>)((BiConsumer<DataTicket, Item>)animationState::setData));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        GeoRenderer.super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(this.currentEntity, 1.0f).m_252839_()));
            bone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.currentEntity.m_20182_().m_252839_()));
        }
        GeoRenderer.super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public Vec3 getRenderOffset(Entity entity, float f) {
        return Vec3.f_82478_;
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        this.lastModel = bakedModel;
        this.head = this.getHeadBone();
        this.body = this.getBodyBone();
        this.rightArm = this.getRightArmBone();
        this.leftArm = this.getLeftArmBone();
        this.rightLeg = this.getRightLegBone();
        this.leftLeg = this.getLeftLegBone();
        this.rightBoot = this.getRightBootBone();
        this.leftBoot = this.getLeftBootBone();
    }

    public void prepForRender(@Nullable Entity entity, ItemStack stack, @Nullable EquipmentSlot slot, @Nullable HumanoidModel<?> baseModel) {
        if (entity == null || slot == null || baseModel == null) {
            return;
        }
        this.baseModel = baseModel;
        this.currentEntity = entity;
        this.currentStack = stack;
        this.animatable = stack.m_41720_();
        this.currentSlot = slot;
    }

    protected void applyBaseModel(HumanoidModel<?> baseModel) {
        this.f_102610_ = baseModel.f_102610_;
        this.f_102817_ = baseModel.f_102817_;
        this.f_102609_ = baseModel.f_102609_;
        this.f_102816_ = baseModel.f_102816_;
        this.f_102815_ = baseModel.f_102815_;
    }

    protected void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
        this.m_8009_(false);
        switch (currentSlot) {
            case HEAD: {
                this.setBoneVisible(this.head, true);
                break;
            }
            case CHEST: {
                this.setBoneVisible(this.body, true);
                this.setBoneVisible(this.rightArm, true);
                this.setBoneVisible(this.leftArm, true);
                break;
            }
            case LEGS: {
                this.setBoneVisible(this.rightLeg, true);
                this.setBoneVisible(this.leftLeg, true);
                break;
            }
            case FEET: {
                this.setBoneVisible(this.rightBoot, true);
                this.setBoneVisible(this.leftBoot, true);
                break;
            }
        }
    }

    public void applyBoneVisibilityByPart(EquipmentSlot currentSlot, ModelPart currentPart, HumanoidModel<?> model) {
        this.m_8009_(false);
        currentPart.f_104207_ = true;
        GeoBone bone = null;
        if (currentPart == model.f_102809_ || currentPart == model.f_102808_) {
            bone = this.head;
        } else if (currentPart == model.f_102810_) {
            bone = this.body;
        } else if (currentPart == model.f_102812_) {
            bone = this.leftArm;
        } else if (currentPart == model.f_102811_) {
            bone = this.rightArm;
        } else if (currentPart == model.f_102814_) {
            bone = currentSlot == EquipmentSlot.FEET ? this.leftBoot : this.leftLeg;
        } else if (currentPart == model.f_102813_) {
            GeoBone geoBone = bone = currentSlot == EquipmentSlot.FEET ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        if (this.head != null) {
            ModelPart headPart = baseModel.f_102808_;
            RenderUtils.matchModelPartRot(headPart, this.head);
            this.head.updatePosition(headPart.f_104200_, -headPart.f_104201_, headPart.f_104202_);
        }
        if (this.body != null) {
            ModelPart bodyPart = baseModel.f_102810_;
            RenderUtils.matchModelPartRot(bodyPart, this.body);
            this.body.updatePosition(bodyPart.f_104200_, -bodyPart.f_104201_, bodyPart.f_104202_);
        }
        if (this.rightArm != null) {
            ModelPart rightArmPart = baseModel.f_102811_;
            RenderUtils.matchModelPartRot(rightArmPart, this.rightArm);
            this.rightArm.updatePosition(rightArmPart.f_104200_ + 5.0f, 2.0f - rightArmPart.f_104201_, rightArmPart.f_104202_);
        }
        if (this.leftArm != null) {
            ModelPart leftArmPart = baseModel.f_102812_;
            RenderUtils.matchModelPartRot(leftArmPart, this.leftArm);
            this.leftArm.updatePosition(leftArmPart.f_104200_ - 5.0f, 2.0f - leftArmPart.f_104201_, leftArmPart.f_104202_);
        }
        if (this.rightLeg != null) {
            ModelPart rightLegPart = baseModel.f_102813_;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
            if (this.rightBoot != null) {
                RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
                this.rightBoot.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
            }
        }
        if (this.leftLeg != null) {
            ModelPart leftLegPart = baseModel.f_102814_;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            if (this.leftBoot != null) {
                RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
                this.leftBoot.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
            }
        }
    }

    public void m_8009_(boolean pVisible) {
        super.m_8009_(pVisible);
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(PoseStack poseStack, T animatable, float partialTick, boolean isReRender) {
        if (!this.f_102610_ || isReRender) {
            return;
        }
        if (this.currentSlot == EquipmentSlot.HEAD) {
            if (this.baseModel.f_102007_) {
                float headScale = 1.5f / this.baseModel.f_102010_;
                poseStack.m_85841_(headScale, headScale, headScale);
            }
            poseStack.m_252880_(0.0f, this.baseModel.f_170338_ / 16.0f, this.baseModel.f_170339_ / 16.0f);
        } else {
            float bodyScale = 1.0f / this.baseModel.f_102011_;
            poseStack.m_85841_(bodyScale, bodyScale, bodyScale);
            poseStack.m_252880_(0.0f, this.baseModel.f_102012_ / 16.0f, 0.0f);
        }
    }

    protected void setBoneVisible(@Nullable GeoBone bone, boolean visible) {
        if (bone == null) {
            return;
        }
        bone.setHidden(!visible);
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        if (this.currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.getTextureLocation((GeoAnimatable)animatable), this.currentEntity.m_19879_() + this.currentEntity.f_19797_);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireCompileArmorRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireArmorPreRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        Services.GEO_RENDER_PHASE_EVENT_FACTORY.fireArmorPostRender(this, poseStack, model, bufferSource, partialTick, packedLight);
    }
}

