/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PrintoutScreen
extends AbstractContainerScreen<PrintoutMenu>
implements ContainerListener {
    private PrintoutInfo printout = PrintoutInfo.DEFAULT;
    private int page = 0;

    public PrintoutScreen(PrintoutMenu container, Inventory player, Component title) {
        super((AbstractContainerMenu)container, player, title);
        this.f_97727_ = 209;
    }

    private void setPrintout(ItemStack stack) {
        String[] text = PrintoutItem.getText(stack);
        TextBuffer[] textBuffers = new TextBuffer[text.length];
        for (int i = 0; i < textBuffers.length; ++i) {
            textBuffers[i] = new TextBuffer(text[i]);
        }
        String[] colours = PrintoutItem.getColours(stack);
        TextBuffer[] colourBuffers = new TextBuffer[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            colourBuffers[i] = new TextBuffer(colours[i]);
        }
        int pages = Math.max(text.length / 21, 1);
        boolean book = stack.m_150930_((Item)ModRegistry.Items.PRINTED_BOOK.get());
        this.printout = new PrintoutInfo(pages, book, textBuffers, colourBuffers);
    }

    protected void m_7856_() {
        super.m_7856_();
        ((PrintoutMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7861_() {
        ((PrintoutMenu)this.f_97732_).m_38943_(this);
    }

    public void m_7934_(AbstractContainerMenu menu, int slot, ItemStack stack) {
        if (slot == 0) {
            this.setPrintout(stack);
        }
    }

    public void m_142153_(AbstractContainerMenu menu, int slot, int data) {
        if (slot == 0) {
            this.page = data;
        }
    }

    private void setPage(int page) {
        this.page = page;
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91072_);
        gameMode.m_105208_(((PrintoutMenu)this.f_97732_).f_38840_, 100 + page);
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    private void nextPage() {
        if (this.page < this.printout.pages() - 1) {
            this.setPage(this.page + 1);
        }
    }

    public boolean m_7933_(int key, int scancode, int modifiers) {
        if (key == 262) {
            this.nextPage();
            return true;
        }
        if (key == 263) {
            this.previousPage();
            return true;
        }
        return super.m_7933_(key, scancode, modifiers);
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (super.m_6050_(x, y, delta)) {
            return true;
        }
        if (delta < 0.0) {
            this.nextPage();
            return true;
        }
        if (delta > 0.0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        MultiBufferSource.BufferSource renderer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PrintoutRenderer.drawBorder(graphics.m_280168_(), (MultiBufferSource)renderer, this.f_97735_, this.f_97736_, 0.0f, this.page, this.printout.pages(), this.printout.book(), 0xF000F0);
        PrintoutRenderer.drawText(graphics.m_280168_(), (MultiBufferSource)renderer, this.f_97735_ + 13, this.f_97736_ + 11, 21 * this.page, 0xF000F0, this.printout.text(), this.printout.colour());
        renderer.m_109911_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, -1.0f);
        this.m_280273_(graphics);
        graphics.m_280168_().m_85849_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    record PrintoutInfo(int pages, boolean book, TextBuffer[] text, TextBuffer[] colour) {
        public static final PrintoutInfo DEFAULT;

        static {
            Object[] textLines = new TextBuffer[21];
            Arrays.fill(textLines, new TextBuffer(" ".repeat(25)));
            Object[] colourLines = new TextBuffer[21];
            Arrays.fill(colourLines, new TextBuffer("f".repeat(25)));
            DEFAULT = new PrintoutInfo(1, false, (TextBuffer[])textLines, (TextBuffer[])colourLines);
        }
    }
}

