/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ServerComputer;
import org.jspecify.annotations.Nullable;

public class ComputerPeripheral
implements IPeripheral {
    private final String type;
    private final AbstractComputerBlockEntity owner;

    public ComputerPeripheral(String type, AbstractComputerBlockEntity owner) {
        this.type = type;
        this.owner = owner;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @LuaFunction
    public final void turnOn() {
        ServerComputer computer = this.owner.getServerComputer();
        if (computer == null) {
            this.owner.startOn = true;
        } else {
            computer.turnOn();
        }
    }

    @LuaFunction
    public final void shutdown() {
        ServerComputer computer = this.owner.getServerComputer();
        if (computer == null) {
            this.owner.startOn = false;
        } else {
            computer.shutdown();
        }
    }

    @LuaFunction
    public final void reboot() {
        ServerComputer computer = this.owner.getServerComputer();
        if (computer == null) {
            this.owner.startOn = true;
        } else {
            computer.reboot();
        }
    }

    @LuaFunction
    public final int getID() {
        ServerComputer computer = this.owner.getServerComputer();
        return computer == null ? this.owner.getComputerID() : computer.getID();
    }

    @LuaFunction
    public final boolean isOn() {
        ServerComputer computer = this.owner.getServerComputer();
        return computer != null && computer.isOn();
    }

    @LuaFunction
    public final @Nullable String getLabel() {
        ServerComputer computer = this.owner.getServerComputer();
        return computer == null ? this.owner.getLabel() : computer.getLabel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (!(other instanceof ComputerPeripheral)) return false;
        ComputerPeripheral computerPeripheral = (ComputerPeripheral)other;
        if (this.owner != computerPeripheral.owner) return false;
        return true;
    }

    @Override
    public Object getTarget() {
        return this.owner;
    }
}

