/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class TerminalState {
    private final boolean colour;
    final int width;
    final int height;
    final int cursorX;
    final int cursorY;
    final boolean cursorBlink;
    final int cursorBgColour;
    final int cursorFgColour;
    final byte[] contents;

    TerminalState(boolean colour, int width, int height, int cursorX, int cursorY, boolean cursorBlink, int cursorFgColour, int cursorBgColour, byte[] contents) {
        this.colour = colour;
        this.width = width;
        this.height = height;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.cursorBlink = cursorBlink;
        this.cursorFgColour = cursorFgColour;
        this.cursorBgColour = cursorBgColour;
        this.contents = contents;
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable TerminalState create(@Nullable NetworkedTerminal terminal) {
        return terminal == null ? null : terminal.write();
    }

    public TerminalState(FriendlyByteBuf buf) {
        this.colour = buf.readBoolean();
        this.width = buf.m_130242_();
        this.height = buf.m_130242_();
        this.cursorX = buf.m_130242_();
        this.cursorY = buf.m_130242_();
        this.cursorBlink = buf.readBoolean();
        byte cursorColour = buf.readByte();
        this.cursorBgColour = cursorColour >> 4 & 0xF;
        this.cursorFgColour = cursorColour & 0xF;
        this.contents = buf.m_130052_();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.colour);
        buf.m_130130_(this.width);
        buf.m_130130_(this.height);
        buf.m_130130_(this.cursorX);
        buf.m_130130_(this.cursorY);
        buf.writeBoolean(this.cursorBlink);
        buf.writeByte(this.cursorBgColour << 4 | this.cursorFgColour);
        buf.m_130087_(this.contents);
    }

    public int size() {
        return this.contents.length;
    }

    public void apply(NetworkedTerminal terminal) {
        terminal.read(this);
    }

    public NetworkedTerminal create() {
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(this);
        return terminal;
    }
}

