/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin;

import net.kyrptonaught.customportalapi.interfaces.EntityInCustomPortal;
import net.kyrptonaught.customportalapi.mixin.PlayerMixin;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin
implements EntityInCustomPortal {
    int portalFrameBlockID;

    public ResourceKey<Level> CPApreventEndCredits(ServerLevel serverWorld) {
        if (this.didTeleport()) {
            Block portalFrame = CustomPortalHelper.getPortalBase((Level)serverWorld, this.getInPortalPos());
            this.portalFrameBlockID = BuiltInRegistries.f_256975_.m_7447_((Object)portalFrame);
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("cpapireforged", "nullworld"));
        }
        return serverWorld.m_46472_();
    }

    @Inject(method={"createEndPlatform"}, at={@At(value="HEAD")}, cancellable=true)
    public void CPAcancelEndPlatformSpawn(ServerLevel world, BlockPos centerPos, CallbackInfo ci) {
        if (this.didTeleport()) {
            ci.cancel();
        }
    }

    public void CPAmodifyWorldEventPacket(ServerGamePacketListenerImpl instance, Packet<?> packet) {
        if (packet instanceof ClientboundLevelEventPacket && this.portalFrameBlockID != 0) {
            instance.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, this.portalFrameBlockID, false));
            this.portalFrameBlockID = 0;
        } else {
            instance.m_9829_(packet);
        }
    }
}

