/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StockKeeperTransferHandler
implements IRecipeTransferHandler<StockKeeperRequestMenu, Object> {
    private IJeiHelpers helpers;

    public StockKeeperTransferHandler(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public Class<? extends StockKeeperRequestMenu> getContainerClass() {
        return StockKeeperRequestMenu.class;
    }

    public Optional<MenuType<StockKeeperRequestMenu>> getMenuType() {
        return Optional.of((MenuType)AllMenuTypes.STOCK_KEEPER_REQUEST.get());
    }

    public RecipeType<Object> getRecipeType() {
        return null;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(StockKeeperRequestMenu container, Object object, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Level level = player.m_9236_();
        if (!(object instanceof Recipe)) {
            return null;
        }
        Recipe recipe = (Recipe)object;
        MutableObject result = new MutableObject();
        if (level.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> result.setValue((Object)this.transferRecipeOnClient(container, recipe, recipeSlots, player, maxTransfer, doTransfer)));
        }
        return (IRecipeTransferError)result.getValue();
    }

    @Nullable
    private IRecipeTransferError transferRecipeOnClient(StockKeeperRequestMenu container, Recipe<?> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Iterator<CraftableBigItemStack> iterator = container.screenReference;
        if (!(iterator instanceof StockKeeperRequestScreen)) {
            return null;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)((Object)iterator);
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (cbis.recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate("gui.stock_keeper.already_ordering_recipe", new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate("gui.stock_keeper.slots_full", new Object[0]).component());
        }
        InventorySummary summary = ((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.m_6262_()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return null;
        }
        RecipeWrapper outputDummy = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(9));
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = 0; i < outputDummy.m_6643_(); ++i) {
            craftingSlots.add(new Slot((Container)outputDummy, i, 0, 0));
        }
        List<BigItemStack> stacksByCount = summary.getStacksByCount();
        RecipeWrapper inputDummy = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(stacksByCount.size()));
        HashMap<Slot, ItemStack> availableItemStacks = new HashMap<Slot, ItemStack>();
        for (int j = 0; j < stacksByCount.size(); ++j) {
            BigItemStack bigItemStack = stacksByCount.get(j);
            availableItemStacks.put(new Slot((Container)inputDummy, j, 0, 0), bigItemStack.stack.m_255036_(bigItemStack.count));
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.helpers.getStackHelper(), availableItemStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), craftingSlots);
        if (!transferOperations.missingItems.isEmpty()) {
            return new RecipeTransferErrorMissingSlots((Component)CreateLang.translate("gui.stock_keeper.not_in_stock", new Object[0]).component(), (Collection)transferOperations.missingItems);
        }
        if (!doTransfer) {
            return null;
        }
        ItemStack result = recipe.m_8043_(player.m_9236_().m_9598_());
        if (result.m_41619_()) {
            return null;
        }
        CraftableBigItemStack cbis = new CraftableBigItemStack(result, recipe);
        screen.recipesToOrder.add(cbis);
        screen.searchBox.m_94144_("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(cbis, maxTransfer ? cbis.stack.m_41741_() : 1);
        return null;
    }
}

