/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.google.common.cache.Cache;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.compat.trainmap.TrainMapSyncPacket;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.TickBasedCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.data.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.PacketDistributor;

public class TrainMapSync {
    public static final int lightPacketInterval = 5;
    public static final int fullPacketInterval = 10;
    public static int ticks;
    public static Cache<UUID, WeakReference<ServerPlayer>> requestingPlayers;

    public static void requestReceived(ServerPlayer sender) {
        boolean sendImmediately = requestingPlayers.getIfPresent((Object)sender.m_20148_()) == null;
        requestingPlayers.put((Object)sender.m_20148_(), new WeakReference<ServerPlayer>(sender));
        if (sendImmediately) {
            TrainMapSync.send(sender.f_8924_, false);
        }
    }

    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (++ticks % 10 == 0) {
            TrainMapSync.send(event.getServer(), false);
        } else if (ticks % 5 == 0) {
            TrainMapSync.send(event.getServer(), true);
        }
    }

    public static void send(MinecraftServer minecraftServer, boolean light) {
        if (requestingPlayers.size() == 0L) {
            return;
        }
        TrainMapSyncPacket packet = new TrainMapSyncPacket(light);
        for (Train train : Create.RAILWAYS.trains.values()) {
            packet.add(train.id, TrainMapSync.createEntry(minecraftServer, train));
        }
        for (WeakReference weakReference : requestingPlayers.asMap().values()) {
            ServerPlayer player = (ServerPlayer)weakReference.get();
            if (player == null) continue;
            AllPackets.getChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }

    private static TrainMapSyncEntry createEntry(MinecraftServer minecraftServer, Train train) {
        GlobalStation currentStation;
        ServerPlayer owner;
        TrainMapSyncEntry entry = new TrainMapSyncEntry();
        boolean stopped = Math.abs(train.speed) < 0.05;
        entry.positions = new float[train.carriages.size() * 6];
        entry.dimensions = new ArrayList<ResourceKey<Level>>();
        List<Carriage> carriages = train.carriages;
        for (int i = 0; i < carriages.size(); ++i) {
            Vec3 trailingPos;
            Vec3 leadingPos;
            Carriage carriage = carriages.get(i);
            if (train.graph == null) {
                Pair<ResourceKey<Level>, Carriage.DimensionalCarriageEntity> dimCarriage = carriage.anyAvailableDimensionalCarriage();
                if (dimCarriage == null || carriage.presentInMultipleDimensions()) {
                    entry.dimensions.add(null);
                    continue;
                }
                leadingPos = (Vec3)((Carriage.DimensionalCarriageEntity)dimCarriage.getSecond()).rotationAnchors.getFirst();
                trailingPos = (Vec3)((Carriage.DimensionalCarriageEntity)dimCarriage.getSecond()).rotationAnchors.getSecond();
                if (leadingPos == null || trailingPos == null) {
                    entry.dimensions.add(null);
                    continue;
                }
                entry.dimensions.add((ResourceKey<Level>)((ResourceKey)dimCarriage.getFirst()));
            } else {
                TravellingPoint leading = carriage.getLeadingPoint();
                TravellingPoint trailing = carriage.getTrailingPoint();
                if (leading == null || trailing == null || leading.edge == null || trailing.edge == null) {
                    entry.dimensions.add(null);
                    continue;
                }
                ResourceKey<Level> leadingDim = leading.node1 == null || leading.edge == null || leading.edge.isInterDimensional() ? null : leading.node1.getLocation().getDimension();
                ResourceKey<Level> trailingDim = trailing.node1 == null || trailing.edge == null || trailing.edge.isInterDimensional() ? null : trailing.node1.getLocation().getDimension();
                ResourceKey<Level> carriageDim = leadingDim == null || leadingDim != trailingDim ? null : leadingDim;
                entry.dimensions.add(carriageDim);
                leadingPos = leading.getPosition(train.graph);
                trailingPos = trailing.getPosition(train.graph);
            }
            entry.positions[i * 6] = (float)leadingPos.m_7096_();
            entry.positions[i * 6 + 1] = (float)leadingPos.m_7098_();
            entry.positions[i * 6 + 2] = (float)leadingPos.m_7094_();
            entry.positions[i * 6 + 3] = (float)trailingPos.m_7096_();
            entry.positions[i * 6 + 4] = (float)trailingPos.m_7098_();
            entry.positions[i * 6 + 5] = (float)trailingPos.m_7094_();
        }
        entry.backwards = train.currentlyBackwards;
        if (train.owner != null && (owner = minecraftServer.m_6846_().m_11259_(train.owner)) != null) {
            entry.ownerName = owner.m_7755_().getString();
        }
        if (train.derailed) {
            entry.state = TrainState.DERAILED;
            return entry;
        }
        ScheduleRuntime runtime = train.runtime;
        if (runtime.getSchedule() != null && stopped) {
            if (runtime.paused) {
                entry.state = TrainState.SCHEDULE_INTERRUPTED;
                return entry;
            }
            if (train.status.conductor) {
                entry.state = TrainState.CONDUCTOR_MISSING;
                return entry;
            }
            if (train.status.navigation) {
                entry.state = TrainState.NAVIGATION_FAILED;
                return entry;
            }
        }
        if ((runtime.getSchedule() == null || runtime.paused) && train.speed != 0.0) {
            entry.state = TrainState.RUNNING_MANUALLY;
        }
        if ((currentStation = train.getCurrentStation()) != null) {
            entry.targetStationName = currentStation.name;
            entry.targetStationDistance = 0;
        } else if (train.navigation.destination != null && !runtime.paused) {
            entry.targetStationName = train.navigation.destination.name;
            entry.targetStationDistance = Math.max(0, Mth.m_14107_((double)train.navigation.distanceToDestination));
        }
        if (stopped && train.navigation.waitingForSignal != null) {
            UUID signalId = (UUID)train.navigation.waitingForSignal.getFirst();
            boolean side = (Boolean)train.navigation.waitingForSignal.getSecond();
            SignalBoundary signal = train.graph.getPoint(EdgePointType.SIGNAL, signalId);
            if (signal != null) {
                boolean chainSignal = signal.types.get(side) == SignalBlock.SignalType.CROSS_SIGNAL;
                SignalState signalState = entry.signalState = chainSignal ? SignalState.CHAIN_SIGNAL : SignalState.BLOCK_SIGNAL;
                if (signal.isForcedRed(side)) {
                    entry.signalState = SignalState.WAITING_FOR_REDSTONE;
                } else {
                    SignalEdgeGroup group = Create.RAILWAYS.signalEdgeGroups.get(signal.groups.get(side));
                    if (group != null) {
                        for (Train other : group.trains) {
                            if (other == train) continue;
                            entry.waitingForTrain = other.id;
                            break;
                        }
                    }
                }
            }
        }
        if (train.fuelTicks > 0 && !stopped) {
            entry.fueled = true;
        }
        return entry;
    }

    static {
        requestingPlayers = new TickBasedCache<UUID, WeakReference<ServerPlayer>>(20, false);
    }

    public static class TrainMapSyncEntry {
        public float[] prevPositions;
        public List<ResourceKey<Level>> prevDims;
        public float[] positions;
        public List<ResourceKey<Level>> dimensions;
        public TrainState state = TrainState.RUNNING;
        public SignalState signalState = SignalState.NOT_WAITING;
        public boolean fueled = false;
        public boolean backwards = false;
        public int targetStationDistance = 0;
        public String ownerName = "";
        public String targetStationName = "";
        public UUID waitingForTrain = null;

        public void gatherDimensions(DimensionPalette dimensionPalette) {
            for (ResourceKey<Level> resourceKey : this.dimensions) {
                if (resourceKey == null) continue;
                dimensionPalette.encode(resourceKey);
            }
        }

        public void send(FriendlyByteBuf buffer, DimensionPalette dimensionPalette, boolean light) {
            buffer.m_130130_(this.positions.length);
            for (float f : this.positions) {
                buffer.writeFloat(f);
            }
            buffer.m_130130_(this.dimensions.size());
            Object object = this.dimensions.iterator();
            while (object.hasNext()) {
                ResourceKey resourceKey = (ResourceKey)object.next();
                buffer.m_130130_(resourceKey == null ? -1 : dimensionPalette.encode((ResourceKey<Level>)resourceKey));
            }
            buffer.m_130130_(this.state.ordinal());
            buffer.m_130130_(this.signalState.ordinal());
            buffer.writeBoolean(this.fueled);
            buffer.writeBoolean(this.backwards);
            buffer.m_130130_(this.targetStationDistance);
            if (light) {
                return;
            }
            buffer.m_130070_(this.ownerName);
            buffer.m_130070_(this.targetStationName);
            buffer.writeBoolean(this.waitingForTrain != null);
            if (this.waitingForTrain != null) {
                buffer.m_130077_(this.waitingForTrain);
            }
        }

        public void receive(FriendlyByteBuf buffer, DimensionPalette dimensionPalette, boolean light) {
            this.positions = new float[buffer.m_130242_()];
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = buffer.readFloat();
            }
            this.dimensions = new ArrayList<ResourceKey<Level>>();
            int dimensionsSize = buffer.m_130242_();
            for (int i = 0; i < dimensionsSize; ++i) {
                int index = buffer.m_130242_();
                this.dimensions.add(index == -1 ? null : dimensionPalette.decode(index));
            }
            this.state = TrainState.values()[buffer.m_130242_()];
            this.signalState = SignalState.values()[buffer.m_130242_()];
            this.fueled = buffer.readBoolean();
            this.backwards = buffer.readBoolean();
            this.targetStationDistance = buffer.m_130242_();
            if (light) {
                return;
            }
            this.ownerName = buffer.m_130277_();
            this.targetStationName = buffer.m_130277_();
            this.waitingForTrain = null;
            if (buffer.readBoolean()) {
                this.waitingForTrain = buffer.m_130259_();
            }
        }

        public void updateFrom(TrainMapSyncEntry other, boolean light) {
            this.prevPositions = this.positions;
            this.prevDims = this.dimensions;
            this.positions = other.positions;
            this.dimensions = other.dimensions;
            this.state = other.state;
            this.signalState = other.signalState;
            this.fueled = other.fueled;
            this.backwards = other.backwards;
            this.targetStationDistance = other.targetStationDistance;
            if (this.prevDims != null) {
                for (int i = 0; i < Math.min(this.prevDims.size(), this.dimensions.size()); ++i) {
                    if (this.prevDims.get(i) == this.dimensions.get(i)) continue;
                    for (int j = 0; j < 6; ++j) {
                        this.prevPositions[i * 6 + j] = this.positions[i * 6 + j];
                    }
                }
            }
            if (light) {
                return;
            }
            this.ownerName = other.ownerName;
            this.targetStationName = other.targetStationName;
            this.waitingForTrain = other.waitingForTrain;
        }

        public Vec3 getPosition(int carriageIndex, boolean firstBogey, double time) {
            int startIndex = carriageIndex * 6 + (firstBogey ? 0 : 3);
            if (this.positions == null || this.positions.length <= startIndex + 2) {
                return Vec3.f_82478_;
            }
            Vec3 position = new Vec3((double)this.positions[startIndex], (double)this.positions[startIndex + 1], (double)this.positions[startIndex + 2]);
            if (this.prevPositions == null || this.prevPositions.length <= startIndex + 2) {
                return position;
            }
            Vec3 prevPosition = new Vec3((double)this.prevPositions[startIndex], (double)this.prevPositions[startIndex + 1], (double)this.prevPositions[startIndex + 2]);
            return prevPosition.m_165921_(position, time);
        }
    }

    public static enum TrainState {
        RUNNING,
        RUNNING_MANUALLY,
        DERAILED,
        SCHEDULE_INTERRUPTED,
        CONDUCTOR_MISSING,
        NAVIGATION_FAILED;

    }

    public static enum SignalState {
        NOT_WAITING,
        WAITING_FOR_REDSTONE,
        BLOCK_SIGNAL,
        CHAIN_SIGNAL;

    }
}

