/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.items;

import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.core.placement.TubePlacement;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class HypertubeItem
extends BlockItem {
    public HypertubeItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player == null) {
            return super.m_6225_(pContext);
        }
        if (pContext.m_43724_() == InteractionHand.OFF_HAND) {
            return super.m_6225_(pContext);
        }
        if (player.m_6144_() && !this.m_5812_(stack)) {
            return super.m_6225_(pContext);
        }
        Direction direction = pContext.m_43719_();
        MessageUtils.sendActionMessage(player, "");
        if (!this.m_5812_(stack)) {
            ResponseDTO select = HypertubeItem.select((LevelAccessor)level, pos, direction, stack);
            if (select.valid()) {
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!select.errorMessage().isEmpty()) {
                MessageUtils.sendActionMessage(player, (Component)select.getMessageComponent());
            }
            return super.m_6225_(pContext);
        }
        SimpleConnection simpleConnection = ModDataComponent.decodeSimpleConnection(stack);
        if (player.m_6144_()) {
            MessageUtils.sendActionMessage(player, (Component)Component.m_237115_((String)"placement.create_hypertube.conn_cleared").m_130940_(ChatFormatting.YELLOW));
            HypertubeItem.clearConnection(stack);
            return InteractionResult.SUCCESS;
        }
        if (simpleConnection.pos().equals((Object)pos)) {
            player.m_5496_(SoundEvents.f_12016_, 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        boolean isHypertubeClicked = state.m_60734_() instanceof ITubeConnection;
        boolean success = false;
        if (isHypertubeClicked) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ITubeConnectionEntity) {
                ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
                success = TubePlacement.handleHypertubeClicked(tube, player, simpleConnection, pos, direction, level, stack);
            }
            SoundType soundtype = state.m_60827_();
            if (success) {
                level.m_5594_(null, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            } else {
                level.m_5594_(player, pos, (SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
        return isHypertubeClicked ? InteractionResult.FAIL : super.m_6225_(pContext);
    }

    public static ResponseDTO select(LevelAccessor world, BlockPos pos, Direction direction, ItemStack heldItem) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (!(block instanceof ITubeConnection)) {
            return ResponseDTO.get(false);
        }
        ITubeConnection tube = (ITubeConnection)block;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return ResponseDTO.get(false);
        }
        ITubeConnectionEntity blockEntity2 = (ITubeConnectionEntity)blockEntity;
        if (!blockEntity2.getFacesConnectable().contains(direction) || tube.isConnected(world, pos, direction)) {
            return ResponseDTO.get(false, "placement.create_hypertube.cant_conn_to_face");
        }
        ModDataComponent.encodeSimpleConnection(pos, direction, heldItem);
        heldItem.m_41783_().m_128379_("foil", true);
        return ResponseDTO.get(true);
    }

    public static void clearConnection(ItemStack stack) {
        stack.m_41783_().m_128473_("foil");
        ModDataComponent.removeSimpleConnection(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41783_() != null && (stack.m_41783_().m_128441_("foil") || stack.m_41793_());
    }
}

