/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.firing;

import com.happysg.radar.block.controller.pitch.AutoPitchControllerBlockEntity;
import com.happysg.radar.block.controller.yaw.AutoYawControllerBlockEntity;
import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.compat.cbc.CannonTargeting;
import com.happysg.radar.compat.cbc.CannonUtil;
import com.mojang.logging.LogUtils;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;

public class FiringControlBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TARGET_TIMEOUT_TICKS = 20;
    private TargetingConfig targetingConfig = TargetingConfig.DEFAULT;
    private Vec3 target;
    private boolean firing;
    private boolean prevAssemblyPowered = false;
    private boolean prevFirePowered = false;
    public final CannonMountBlockEntity cannonMount;
    public final AutoPitchControllerBlockEntity pitchController;
    public final Level level;
    public List<AABB> safeZones = new ArrayList<AABB>();
    private long lastTargetTick = -1L;

    public FiringControlBlockEntity(AutoPitchControllerBlockEntity controller, CannonMountBlockEntity cannonMount) {
        this.cannonMount = cannonMount;
        this.pitchController = controller;
        this.level = cannonMount.m_58904_();
        LOGGER.debug("FiringControlBlockEntity.<init>() \u2192 controller={} mountPos={}", (Object)controller, (Object)cannonMount.m_58899_());
    }

    public void setSafeZones(List<AABB> safeZones) {
        LOGGER.debug("setSafeZones() \u2192 {} zones", (Object)safeZones.size());
        this.safeZones = safeZones;
    }

    public void tick() {
        boolean shouldFire;
        LOGGER.debug("tick() start \u2192 target={} lastTargetTick={} safeZones={} autoFire={} firing={}", new Object[]{this.target, this.lastTargetTick, this.safeZones.size(), this.targetingConfig.autoFire(), this.firing});
        boolean pulsedThisTick = false;
        if (this.target != null && this.level != null && this.level.m_46467_() - this.lastTargetTick > 20L) {
            LOGGER.debug("  \u2192 target stale ({} ticks old), clearing", (Object)(this.level.m_46467_() - this.lastTargetTick));
            this.target = null;
        }
        boolean inRange = this.isTargetInRange();
        boolean autoFire = this.targetingConfig.autoFire();
        LOGGER.debug("  \u2192 inRange={} autoFire={}", (Object)inRange, (Object)autoFire);
        boolean bl = shouldFire = this.isTargetInRange() && this.targetingConfig.autoFire();
        if (inRange && autoFire) {
            LOGGER.debug("  \u2192 firing condition met");
            this.tryFireCannon();
        } else {
            LOGGER.debug("  \u2192 firing condition not met");
            this.stopFireCannon();
        }
        if (shouldFire) {
            if (!pulsedThisTick) {
                this.tryFireCannon();
                pulsedThisTick = true;
            }
        } else {
            this.stopFireCannon();
        }
    }

    public void setTarget(Vec3 target, TargetingConfig config) {
        BlockEntity blockEntity;
        BlockPos yawPos;
        LOGGER.debug("setTarget() \u2192 new target={} config={} atTick={}", new Object[]{target, config, this.level != null ? this.level.m_46467_() : -1L});
        if (target == null) {
            LOGGER.debug("  \u2192 target null, stopping fire");
            this.target = null;
            this.stopFireCannon();
            return;
        }
        this.target = target;
        this.targetingConfig = config;
        this.lastTargetTick = this.level != null ? this.level.m_46467_() : 0L;
        LOGGER.debug("  \u2192 stored target & config; lastTargetTick={}", (Object)this.lastTargetTick);
        if (this.pitchController != null) {
            LOGGER.debug("  \u2192 forwarding target to pitchController");
            this.pitchController.setTarget(target);
        }
        if (!(this.level.m_7702_(yawPos = this.cannonMount.m_58899_().m_7495_()) instanceof AutoYawControllerBlockEntity)) {
            yawPos = this.cannonMount.m_58899_().m_7494_();
            LOGGER.debug("  \u2192 yawPos = {}", (Object)yawPos);
        }
        if ((blockEntity = this.level.m_7702_(yawPos)) instanceof AutoYawControllerBlockEntity) {
            AutoYawControllerBlockEntity yawCtrl = (AutoYawControllerBlockEntity)blockEntity;
            LOGGER.debug("  \u2192 forwarding target to yawController at {}", (Object)yawPos);
            yawCtrl.setTarget(target);
        }
    }

    private boolean isTargetInRange() {
        boolean hasTarget = this.target != null;
        boolean correctOrient = this.hasCorrectYawPitch();
        boolean safeZoneClear = !this.passesSafeZone();
        LOGGER.debug("isTargetInRange() check \u2192 hasTarget={}, yawPitchOK={}, safeZoneClear={}", new Object[]{hasTarget, correctOrient, safeZoneClear});
        return hasTarget && correctOrient && safeZoneClear;
    }

    private boolean passesSafeZone() {
        LOGGER.debug("passesSafeZone() \u2192 checking {} safe zones", (Object)this.safeZones.size());
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            LOGGER.debug("  \u2192 not server level, skip safe-zone check");
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.target == null) {
            LOGGER.warn("  \u2192 target is null, skipping safe zone check");
            return false;
        }
        Vec3 cannonPos = this.cannonMount.m_58899_().m_252807_();
        for (AABB zone : this.safeZones) {
            Contraption contraption;
            if (zone == null) continue;
            if (zone.m_82390_(this.target)) {
                LOGGER.debug("  \u2192 target {} inside zone {}", (Object)this.target, (Object)zone);
                return true;
            }
            Vec3 baseCannon = new Vec3(cannonPos.f_82479_, zone.f_82289_, cannonPos.f_82481_);
            Vec3 baseTarget = new Vec3(this.target.f_82479_, zone.f_82289_, this.target.f_82481_);
            Optional oMin = zone.m_82371_(baseCannon, baseTarget);
            Optional oMax = zone.m_82371_(baseTarget, baseCannon);
            if (oMin.isEmpty() || oMax.isEmpty()) {
                LOGGER.debug("  \u2192 no intersection segment for zone {}", (Object)zone);
                continue;
            }
            Vec3 minX = (Vec3)oMin.get();
            Vec3 maxX = (Vec3)oMax.get();
            double yMin = zone.f_82289_ - (double)this.cannonMount.m_58899_().m_123342_();
            double yMax = zone.f_82292_ - (double)this.cannonMount.m_58899_().m_123342_();
            LOGGER.debug("  yMin: {}, yMax: {}", (Object)yMin, (Object)yMax);
            PitchOrientedContraptionEntity contraption2 = this.cannonMount.getContraption();
            if (contraption2 == null || !((contraption = contraption2.getContraption()) instanceof AbstractMountedCannonContraption)) {
                LOGGER.warn("  \u2192 cannon contraption missing or invalid, skipping");
                continue;
            }
            AbstractMountedCannonContraption cc = (AbstractMountedCannonContraption)contraption;
            float speed = CannonUtil.getInitialVelocity(cc, serverLevel);
            double drag = CannonUtil.getProjectileDrag(cc, serverLevel);
            double grav = CannonUtil.getProjectileGravity(cc, serverLevel);
            int length = CannonUtil.getBarrelLength(cc);
            LOGGER.debug("  Speed: {}, Drag: {}, Grav: {}, Length: {}", new Object[]{Float.valueOf(speed), drag, grav, length});
            double theta = Math.toRadians(this.cannonMount.getDisplayPitch());
            double distMin = cannonPos.m_82554_(minX) - (double)length * Math.cos(theta);
            double distMax = cannonPos.m_82554_(maxX) - (double)length * Math.cos(theta);
            double yAtMin = CannonTargeting.calculateProjectileYatX(speed, distMin, theta, drag, grav);
            double yAtMax = CannonTargeting.calculateProjectileYatX(speed, distMax, theta, drag, grav);
            LOGGER.debug("  \u2192 zone {}: yAtMin={}, yAtMax={} vs yMin={}, yMax={}", new Object[]{zone, yAtMin, yAtMax, yMin, yMax});
            if (!(yAtMin >= yMin && yAtMax <= yMax) && (!(yAtMin <= yMin) || !(yAtMax >= yMin))) continue;
            LOGGER.debug("  \u2192 trajectory passes through zone {}", (Object)zone);
            return true;
        }
        LOGGER.debug("passesSafeZone() \u2192 false");
        return false;
    }

    private boolean hasCorrectYawPitch() {
        BlockEntity blockEntity;
        LOGGER.debug("hasCorrectYawPitch() start");
        BlockPos below = this.cannonMount.m_58899_().m_7495_();
        if (!(this.level.m_7702_(below) instanceof AutoYawControllerBlockEntity)) {
            below = this.cannonMount.m_58899_().m_7494_();
            LOGGER.debug("  \u2192 no yaw controller at {}", (Object)below);
        }
        if (!((blockEntity = this.level.m_7702_(below)) instanceof AutoYawControllerBlockEntity)) {
            LOGGER.debug("  \u2192 no yaw controller at {}", (Object)below);
            return false;
        }
        AutoYawControllerBlockEntity yawCtrl = (AutoYawControllerBlockEntity)blockEntity;
        boolean ok = yawCtrl.atTargetYaw() && this.pitchController.atTargetPitch();
        LOGGER.debug("  \u2192 yaw ok={}, pitch ok={}", (Object)yawCtrl.atTargetYaw(), (Object)this.pitchController.atTargetPitch());
        return ok;
    }

    private void stopFireCannon() {
        LOGGER.debug("stopFireCannon() \u2192 sending redstone OFF");
        boolean assembly = true;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, false, this.prevFirePowered, 0);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = false;
        this.firing = false;
    }

    private void tryFireCannon() {
        LOGGER.debug("tryFireCannon() \u2192 pulsing redstone ON");
        boolean assembly = true;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, false, this.prevFirePowered, 0);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = false;
        this.cannonMount.onRedstoneUpdate(assembly, this.prevAssemblyPowered, true, this.prevFirePowered, 15);
        this.prevAssemblyPowered = assembly;
        this.prevFirePowered = true;
        this.firing = true;
    }
}

