/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.track;

import com.happysg.radar.compat.Mods;
import com.happysg.radar.compat.vs2.VS2Utils;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaterniondc;
import org.valkyrienskies.core.api.ships.LoadedShip;

public class TrackControllerBlockEntity
extends SplitShaftBlockEntity {
    public Vec3 target;
    public float leftSpeed;
    public float rightSpeed;

    public TrackControllerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public float getRotationSpeedModifier(Direction face) {
        if (this.hasSource() && face == this.getSourceFacing()) {
            return 1.0f;
        }
        if (this.target == null) {
            return 0.0f;
        }
        if (face == this.getSourceFacing().m_122428_()) {
            return this.leftSpeed;
        }
        if (face == this.getSourceFacing().m_122427_()) {
            return this.rightSpeed;
        }
        return 1.0f;
    }

    public Direction getSourceFacing() {
        return ((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122424_();
    }

    public void tick() {
        super.tick();
        boolean changed = false;
        if (Math.abs(this.getAngleDifference()) < 20.0) {
            if (this.leftSpeed == 1.0f || this.rightSpeed == 1.0f) {
                changed = true;
            }
            this.leftSpeed = 0.0f;
            this.rightSpeed = 0.0f;
        } else if (this.getAngleDifference() < 180.0) {
            if (this.leftSpeed == 0.0f) {
                changed = true;
            }
            this.leftSpeed = 1.0f;
            this.rightSpeed = 0.0f;
        } else {
            if (this.rightSpeed == 0.0f) {
                changed = true;
            }
            this.leftSpeed = 0.0f;
            this.rightSpeed = 1.0f;
        }
        if (changed) {
            this.detachKinetics();
            this.attachKinetics();
            this.updateSpeed = true;
            this.notifyUpdate();
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        compound.m_128457_("leftSpeed");
        compound.m_128457_("rightSpeed");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("leftSpeed", this.leftSpeed);
        compound.m_128350_("rightSpeed", this.rightSpeed);
    }

    private double getAngleDifference() {
        return this.getAngleToTarget() - this.getYaw();
    }

    private double getAngleToTarget() {
        if (this.target == null) {
            return this.getYaw();
        }
        Vec3 center = VS2Utils.getWorldVec((BlockEntity)this);
        Vec3 relative = center.m_82546_(this.target);
        double yaw = Math.toDegrees(Math.atan2(relative.f_82481_, relative.f_82479_)) - 90.0;
        yaw = (yaw + 360.0) % 360.0;
        return yaw;
    }

    private double getYaw() {
        return (this.toYRot() - this.getAngleOffsetToWorld() + 360.0) % 360.0;
    }

    private double getAngleOffsetToWorld() {
        if (!Mods.VALKYRIENSKIES.isLoaded()) {
            return 0.0;
        }
        LoadedShip ship = VS2Utils.getShipManagingPos((BlockEntity)this);
        if (ship == null) {
            return 0.0;
        }
        Quaterniondc quaterniondc = ship.getTransform().getShipToWorldRotation();
        double qw = quaterniondc.w();
        double qx = quaterniondc.x();
        double qy = quaterniondc.y();
        double qz = quaterniondc.z();
        double yaw = Math.atan2(2.0 * (qw * qy + qx * qz), 1.0 - 2.0 * (qy * qy + qz * qz));
        yaw = Math.toDegrees(yaw);
        yaw = (yaw + 360.0) % 360.0;
        return yaw;
    }

    private double toYRot() {
        Direction direction = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        return switch (direction) {
            case Direction.NORTH -> 0.0;
            case Direction.SOUTH -> 180.0;
            case Direction.WEST -> 270.0;
            case Direction.EAST -> 90.0;
            default -> 0.0;
        };
    }

    public void setTarget(Vec3 targetPos) {
        this.target = targetPos;
    }

    public Vec3 getTarget() {
        return this.target;
    }
}

