/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.datalink;

import com.happysg.radar.block.datalink.DataController;
import com.happysg.radar.block.monitor.MonitorBlockEntity;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.happysg.radar.config.RadarConfig;
import com.happysg.radar.registry.AllDataBehaviors;
import com.happysg.radar.registry.ModBlocks;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DataLinkBlockItem
extends BlockItem {
    private static BlockPos lastShownPos = null;
    private static AABB lastShownAABB = null;

    public DataLinkBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @SubscribeEvent
    public static void gathererItemAlwaysPlacesWhenUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack usedItem = event.getItemStack();
        if (usedItem.m_41720_() instanceof DataLinkBlockItem) {
            if (ModBlocks.RADAR_LINK.has(event.getLevel().m_8055_(event.getPos()))) {
                return;
            }
            event.setUseBlock(Event.Result.DENY);
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Component.m_237115_((String)"display_link.clear"), true);
            stack.m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!(pContext.m_43725_().m_7702_(pContext.m_8083_()) instanceof MonitorBlockEntity)) {
                player.m_5661_((Component)Component.m_237115_((String)"create_radar.data_link.link_to_monitor"), true);
                return InteractionResult.FAIL;
            }
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            player.m_5661_((Component)Component.m_237115_((String)"display_link.set"), true);
            stack.m_41751_(stackTag);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag teTag = new CompoundTag();
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SelectedPos"));
        BlockPos placedPos = pos.m_5484_(pContext.m_43719_(), state.m_247087_() ? 0 : 1);
        if (!PhysicsHandler.getWorldPos(level, selectedPos).m_123314_((Vec3i)PhysicsHandler.getWorldPos(level, placedPos), (double)((Integer)RadarConfig.server().radarLinkRange.get()).intValue())) {
            player.m_5661_((Component)Component.m_237115_((String)"display_link.too_far").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        teTag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placedPos)));
        tag.m_128365_("BlockEntityTag", (Tag)teTag);
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        ItemStack itemInHand = player.m_21120_(pContext.m_43724_());
        if (!itemInHand.m_41619_()) {
            itemInHand.m_41751_(null);
        }
        player.m_5661_((Component)Component.m_237115_((String)"display_link.success").m_130940_(ChatFormatting.GREEN), true);
        return useOn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.m_21205_();
        if (!(heldItemMainhand.m_41720_() instanceof DataLinkBlockItem)) {
            return;
        }
        if (!heldItemMainhand.m_41782_()) {
            return;
        }
        CompoundTag stackTag = heldItemMainhand.m_41784_();
        if (!stackTag.m_128441_("SelectedPos")) {
            return;
        }
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)stackTag.m_128469_("SelectedPos"));
        if (!selectedPos.equals((Object)lastShownPos)) {
            lastShownAABB = DataLinkBlockItem.getBounds(selectedPos);
            lastShownPos = selectedPos;
        }
        Outliner.getInstance().showAABB((Object)"target", lastShownAABB).colored(7317724).lineWidth(0.0625f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AABB getBounds(BlockPos pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        DataController target = AllDataBehaviors.targetOf((LevelAccessor)world, pos);
        if (target != null) {
            return target.getMultiblockBounds((LevelAccessor)world, pos);
        }
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        return shape.m_83281_() ? new AABB(BlockPos.f_121853_) : shape.m_83215_().m_82338_(pos);
    }
}

