/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.monitor;

import com.happysg.radar.block.datalink.screens.TargetingConfig;
import com.happysg.radar.block.monitor.MonitorFilter;
import com.happysg.radar.block.radar.behavior.IRadar;
import com.happysg.radar.block.radar.track.RadarTrack;
import com.happysg.radar.block.radar.track.RadarTrackUtil;
import com.happysg.radar.compat.vs2.PhysicsHandler;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MonitorBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    protected BlockPos controller;
    protected int radius = 1;
    private int ticksSinceLastUpdate = 0;
    protected BlockPos radarPos;
    IRadar radar;
    protected String hoveredEntity;
    protected String selectedEntity;
    Collection<RadarTrack> cachedTracks = List.of();
    MonitorFilter filter = MonitorFilter.DEFAULT;
    public List<AABB> safeZones = new ArrayList<AABB>();

    public MonitorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.updateCache();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void updateCache() {
        this.getRadar().ifPresent(radar -> {
            this.cachedTracks = radar.getTracks().stream().filter(this.filter::test).toList();
        });
    }

    public BlockPos getControllerPos() {
        if (this.controller == null) {
            return this.m_58899_();
        }
        return this.controller;
    }

    public int getSize() {
        return this.radius;
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 0L) {
            this.updateCache();
            this.sendData();
        }
        if (this.ticksSinceLastUpdate > 20) {
            this.setRadarPos(null);
        }
        ++this.ticksSinceLastUpdate;
    }

    public void setControllerPos(BlockPos pPos, int size) {
        this.controller = pPos;
        this.radius = size;
        this.notifyUpdate();
    }

    public void setRadarPos(BlockPos pPos) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.getControllerPos());
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity monitor = (MonitorBlockEntity)blockEntity;
            if (pPos == null) {
                monitor.radarPos = null;
                monitor.radar = null;
                monitor.notifyUpdate();
                return;
            }
            monitor.radarPos = pPos;
            monitor.ticksSinceLastUpdate = 0;
            monitor.notifyUpdate();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        this.controller = null;
        this.radarPos = null;
        this.radar = null;
        super.read(tag, clientPacket);
        if (tag.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Controller"));
        }
        if (tag.m_128441_("radarPos")) {
            this.radarPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("radarPos"));
        }
        this.selectedEntity = tag.m_128441_("SelectedEntity") ? tag.m_128461_("SelectedEntity") : null;
        this.hoveredEntity = tag.m_128441_("HoveredEntity") ? tag.m_128461_("HoveredEntity") : null;
        this.filter = MonitorFilter.fromTag(tag.m_128469_("Filter"));
        this.radius = tag.m_128451_("Size");
        if (clientPacket) {
            this.cachedTracks = RadarTrackUtil.deserializeListNBT(tag.m_128469_("tracks"));
        }
        this.readSafeZones(tag);
    }

    private void readSafeZones(CompoundTag tag) {
        ListTag safeZonesTag = tag.m_128437_("SafeZones", 10);
        for (int i = 0; i < safeZonesTag.size(); ++i) {
            CompoundTag safeZoneTag = safeZonesTag.m_128728_(i);
            AABB safeZone = new AABB(safeZoneTag.m_128459_("minX"), safeZoneTag.m_128459_("minY"), safeZoneTag.m_128459_("minZ"), safeZoneTag.m_128459_("maxX"), safeZoneTag.m_128459_("maxY"), safeZoneTag.m_128459_("maxZ"));
            this.safeZones.add(safeZone);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.controller != null) {
            tag.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.radarPos != null) {
            tag.m_128365_("radarPos", (Tag)NbtUtils.m_129224_((BlockPos)this.radarPos));
        }
        if (this.selectedEntity != null) {
            tag.m_128359_("SelectedEntity", this.selectedEntity);
        }
        if (this.hoveredEntity != null) {
            tag.m_128359_("HoveredEntity", this.hoveredEntity);
        }
        tag.m_128365_("Filter", (Tag)this.filter.toTag());
        tag.m_128405_("Size", this.radius);
        if (clientPacket) {
            tag.m_128365_("tracks", (Tag)RadarTrackUtil.serializeNBTList(this.cachedTracks));
        }
        tag.m_128365_("SafeZones", (Tag)this.saveSafeZones());
    }

    @NotNull
    private ListTag saveSafeZones() {
        ListTag safeZonesTag = new ListTag();
        for (AABB safeZone : this.safeZones) {
            CompoundTag safeZoneTag = new CompoundTag();
            safeZoneTag.m_128347_("minX", safeZone.f_82288_);
            safeZoneTag.m_128347_("minY", safeZone.f_82289_);
            safeZoneTag.m_128347_("minZ", safeZone.f_82290_);
            safeZoneTag.m_128347_("maxX", safeZone.f_82291_);
            safeZoneTag.m_128347_("maxY", safeZone.f_82292_);
            safeZoneTag.m_128347_("maxZ", safeZone.f_82293_);
            safeZonesTag.add((Object)safeZoneTag);
        }
        return safeZonesTag;
    }

    public boolean isController() {
        return this.m_58899_().equals((Object)this.controller) || this.controller == null;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(10.0);
    }

    public Optional<IRadar> getRadar() {
        if (this.radar != null) {
            return Optional.of(this.radar);
        }
        if (this.radarPos == null) {
            return Optional.empty();
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.radarPos);
        if (blockEntity instanceof IRadar) {
            IRadar radar;
            this.radar = radar = (IRadar)blockEntity;
        }
        return Optional.ofNullable(this.radar);
    }

    public MonitorBlockEntity getController() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof MonitorBlockEntity) {
            MonitorBlockEntity controller = (MonitorBlockEntity)blockEntity;
            return controller;
        }
        return this;
    }

    public Vec3 getTargetPos(TargetingConfig targetingConfig) {
        AtomicReference targetPos = new AtomicReference();
        this.getRadar().ifPresent(radar -> {
            if (this.selectedEntity == null) {
                this.tryFindAutoTarget(targetingConfig);
            }
            if (this.selectedEntity == null) {
                return;
            }
            for (RadarTrack track : this.getController().cachedTracks) {
                if (!track.id().equals(this.selectedEntity)) continue;
                targetPos.set(track.position());
            }
        });
        if (targetPos.get() == null) {
            this.selectedEntity = null;
        } else if (this.isInSafeZone((Vec3)targetPos.get())) {
            return null;
        }
        return (Vec3)targetPos.get();
    }

    private void tryFindAutoTarget(TargetingConfig targetingConfig) {
        if (!targetingConfig.autoTarget()) {
            return;
        }
        double[] distance = new double[]{Double.MAX_VALUE};
        this.getRadar().ifPresent(radar -> {
            for (RadarTrack track : this.getController().cachedTracks) {
                if (!targetingConfig.test(track.trackCategory()) || !(track.position().m_82554_(Vec3.m_82512_((Vec3i)this.getControllerPos())) < distance[0]) || this.isInSafeZone(track.position())) continue;
                this.selectedEntity = track.id();
                distance[0] = track.position().m_82554_(Vec3.m_82512_((Vec3i)this.getControllerPos()));
            }
        });
        if (this.selectedEntity != null) {
            this.notifyUpdate();
        }
    }

    public void setFilter(MonitorFilter filter) {
        this.getController().filter = filter;
        this.filter = filter;
    }

    public Collection<RadarTrack> getTracks() {
        return this.cachedTracks;
    }

    @Nullable
    public Vec3 getRadarCenterPos() {
        if (this.radarPos == null) {
            return null;
        }
        return PhysicsHandler.getWorldVec(this.f_58857_, this.radarPos);
    }

    public float getRange() {
        return this.getRadar().map(IRadar::getRange).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean isInSafeZone(Vec3 pos) {
        for (AABB safeZone : this.safeZones) {
            if (!safeZone.m_82390_(pos)) continue;
            return true;
        }
        return false;
    }

    public void addSafeZone(BlockPos startPos, BlockPos endPos) {
        double minX = Math.min(startPos.m_123341_(), endPos.m_123341_());
        double minY = Math.min(startPos.m_123342_(), endPos.m_123342_());
        double minZ = Math.min(startPos.m_123343_(), endPos.m_123343_());
        double maxX = Math.max(startPos.m_123341_(), endPos.m_123341_());
        double maxY = Math.max(startPos.m_123342_(), endPos.m_123342_());
        double maxZ = Math.max(startPos.m_123343_(), endPos.m_123343_());
        this.getController().safeZones.add(new AABB(minX, minY, minZ, maxX += 1.0, maxY += 1.0, maxZ += 1.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showSafeZone() {
        for (AABB safeZone : this.safeZones) {
            Outliner.getInstance().showAABB((Object)safeZone, safeZone).colored(3685186).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f);
        }
    }

    public boolean tryRemoveAABB(BlockPos pos) {
        return this.safeZones.removeIf(safeZone -> safeZone.m_82390_(Vec3.m_82512_((Vec3i)pos)));
    }

    public String getHoveredEntity() {
        return this.hoveredEntity;
    }

    public String getSelectedEntity() {
        return this.selectedEntity;
    }
}

