/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCEntityTypes;
import rbasamoyai.createbigcannons.index.CBCMunitionPropertiesHandlers;
import rbasamoyai.createbigcannons.munitions.big_cannon.AbstractBigCannonProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.FuzedProjectileBlock;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.AbstractFluidShellBlockEntity;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProjectile;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidShellProperties;

public class FluidShellBlock
extends FuzedProjectileBlock<AbstractFluidShellBlockEntity, FluidShellProjectile> {
    public FluidShellBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<AbstractFluidShellBlockEntity> getBlockEntityClass() {
        return AbstractFluidShellBlockEntity.class;
    }

    public BlockEntityType<? extends AbstractFluidShellBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.FLUID_SHELL.get();
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, List<StructureTemplate.StructureBlockInfo> projectileBlocks) {
        BlockEntity load;
        StructureTemplate.StructureBlockInfo info;
        FluidShellProjectile projectile = (FluidShellProjectile)CBCEntityTypes.FLUID_SHELL.create(level);
        projectile.setFuze(FluidShellBlock.getFuzeFromBlocks(projectileBlocks));
        projectile.setTracer(FluidShellBlock.getTracerFromBlocks(projectileBlocks));
        if (!projectileBlocks.isEmpty() && (info = projectileBlocks.get(0)).f_74677_() != null && (load = BlockEntity.m_155241_((BlockPos)info.f_74675_(), (BlockState)info.f_74676_(), (CompoundTag)info.f_74677_())) instanceof AbstractFluidShellBlockEntity) {
            AbstractFluidShellBlockEntity shell = (AbstractFluidShellBlockEntity)load;
            shell.setFluidShellStack(projectile);
        }
        return projectile;
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, ItemStack itemStack) {
        FluidShellProjectile projectile = (FluidShellProjectile)CBCEntityTypes.FLUID_SHELL.create(level);
        projectile.setFuze(FluidShellBlock.getFuzeFromItemStack(itemStack));
        projectile.setTracer(FluidShellBlock.getTracerFromItemStack(itemStack));
        CompoundTag tag = itemStack.m_41784_();
        CompoundTag fluidTag = tag.m_128469_("BlockEntityTag").m_128469_("FluidContent");
        projectile.setFluidStack(EndFluidStack.readTag(fluidTag));
        return projectile;
    }

    @Override
    public AbstractBigCannonProjectile getProjectile(Level level, BlockPos pos, BlockState state) {
        FluidShellProjectile projectile = (FluidShellProjectile)this.getAssociatedEntityType().m_20615_(level);
        projectile.setTracer(FluidShellBlock.getTracerFromBlock(level, pos, state));
        projectile.setFuze(FluidShellBlock.getFuzeFromBlock(level, pos, state));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractFluidShellBlockEntity) {
            AbstractFluidShellBlockEntity fluidShell = (AbstractFluidShellBlockEntity)blockEntity;
            fluidShell.setFluidShellStack(projectile);
        }
        return projectile;
    }

    @Override
    public EntityType<? extends FluidShellProjectile> getAssociatedEntityType() {
        return (EntityType)CBCEntityTypes.FLUID_SHELL.get();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Direction facing = hit.m_82434_();
        Direction targetDir = this.isBaseFuze() ? ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() : (Direction)state.m_61143_((Property)f_52588_);
        boolean correctOrientation = facing == targetDir;
        return this.onBlockEntityUse((BlockGetter)level, pos, shell -> {
            if (!stack.m_41619_() && correctOrientation) {
                if (shell.tryEmptyItemIntoTE(level, player, hand, stack, facing)) {
                    return InteractionResult.SUCCESS;
                }
                if (shell.tryFillItemFromTE(level, player, hand, stack, facing)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        });
    }

    @Override
    public boolean isBaseFuze() {
        return ((FluidShellProperties)CBCMunitionPropertiesHandlers.FLUID_SHELL.getPropertiesOf(this.getAssociatedEntityType())).fuze().baseFuze();
    }
}

