/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.bulk_fermenter;

import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermenterBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BulkFermentingRecipe
extends ProcessingRecipe<SmartInventory> {
    public BulkFermentingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CDGRecipes.BULK_FERMENTING, params);
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory inventory, Level level) {
        return false;
    }

    public boolean test(IItemHandler container) {
        if (container == null) {
            return false;
        }
        for (Ingredient ingredient : this.m_7527_()) {
            boolean valid = false;
            for (int i = 0; i < container.getSlots(); ++i) {
                ItemStack[] items;
                ItemStack stack = container.getStackInSlot(i);
                if (!ingredient.test(stack) || (items = ingredient.m_43908_()).length == 0 || items[0].m_41613_() > stack.m_41613_()) continue;
                valid = true;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    public boolean test(BulkFermenterBlockEntity.BulkFermenterFluidHandler container) {
        if (container == null) {
            return false;
        }
        for (FluidIngredient ingredient : this.getFluidIngredients()) {
            boolean valid = false;
            for (int i = 0; i < container.getTanks(); ++i) {
                FluidStack fluidInTank = container.getFluidInTank(i);
                if (!ingredient.test(fluidInTank) || ingredient.getRequiredAmount() > fluidInTank.getAmount()) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    public void remove(BulkFermenterBlockEntity.BulkFermenterFluidHandler container) {
        if (container == null) {
            return;
        }
        block0: for (FluidIngredient ingredient : this.getFluidIngredients()) {
            for (int i = 0; i < container.getTanks(); ++i) {
                FluidStack fluidInTank = container.getFluidInTank(i);
                if (!ingredient.test(fluidInTank) || ingredient.getRequiredAmount() > fluidInTank.getAmount()) continue;
                FluidStack toDrain = fluidInTank.copy();
                toDrain.setAmount(ingredient.getRequiredAmount());
                container.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                continue block0;
            }
        }
    }

    public void remove(IItemHandler container) {
        if (container == null) {
            return;
        }
        block0: for (Ingredient ingredient : this.m_7527_()) {
            for (int i = 0; i < container.getSlots(); ++i) {
                ItemStack[] items;
                ItemStack stack = container.getStackInSlot(i);
                if (!ingredient.test(stack) || (items = ingredient.m_43908_()).length == 0 || items[0].m_41613_() > stack.m_41613_()) continue;
                container.extractItem(i, items[0].m_41613_(), false);
                continue block0;
            }
        }
    }

    public boolean apply(BulkFermenterBlockEntity be, boolean test) {
        IItemHandler availableItems = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler fluidCap = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || fluidCap == null || !(fluidCap instanceof BulkFermenterBlockEntity.BulkFermenterFluidHandler)) {
            return false;
        }
        BulkFermenterBlockEntity.BulkFermenterFluidHandler availableFluids = (BulkFermenterBlockEntity.BulkFermenterFluidHandler)fluidCap;
        BlazeBurnerBlock.HeatLevel heat = be.highestHeatLevel;
        if (!this.getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(this.m_7527_());
        NonNullList fluidIngredients = this.getFluidIngredients();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Ingredient ingredient : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            block3: for (FluidIngredient fluidIngredient : fluidIngredients) {
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                be.onFluidStackChanged();
            }
            if (simulate) {
                recipeOutputItems.addAll(this.rollResults());
                for (FluidStack fluidStack : this.getFluidResults()) {
                    if (fluidStack.isEmpty()) continue;
                    recipeOutputFluids.add(fluidStack);
                }
            }
            if (this.applyOutputs(be, recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    private boolean applyOutputs(BulkFermenterBlockEntity be, List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean test) {
        IItemHandler availableItems = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler fluidCap = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || fluidCap == null || !(fluidCap instanceof BulkFermenterBlockEntity.BulkFermenterFluidHandler)) {
            return false;
        }
        BulkFermenterBlockEntity.BulkFermenterFluidHandler availableFluids = (BulkFermenterBlockEntity.BulkFermenterFluidHandler)fluidCap;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            items.add(availableItems.getStackInSlot(i).m_41777_());
        }
        for (ProcessingOutput result : this.getRollableResults()) {
            ItemStack stack = result.getStack().m_41777_();
            int left = stack.m_41613_();
            for (ItemStack slot : items) {
                if (slot.m_41720_() != stack.m_41720_() || !Objects.equals(slot.m_41783_(), stack.m_41783_())) continue;
                if (availableItems.getSlotLimit(0) - slot.m_41613_() >= left) {
                    left = 0;
                    break;
                }
                return false;
            }
            if (left <= 0) continue;
            for (ItemStack slot : items) {
                if (!slot.m_41619_()) continue;
                left = 0;
                break;
            }
            if (left <= 0) continue;
            return false;
        }
        boolean[] emptyTanksFilled = new boolean[availableFluids.tankCount];
        for (FluidStack result : this.getFluidResults()) {
            result = result.copy();
            boolean filled = false;
            for (FluidTank tank : availableFluids.tanks) {
                if (!tank.getFluid().isFluidEqual(result)) continue;
                if (tank.fill(result, IFluidHandler.FluidAction.SIMULATE) < result.getAmount()) {
                    return false;
                }
                filled = true;
            }
            if (filled) continue;
            NonNullList<FluidTank> tanks = availableFluids.tanks;
            for (int i = 0; i < tanks.size(); ++i) {
                FluidTank tank = (FluidTank)tanks.get(i);
                if (!tank.getFluid().isEmpty() || emptyTanksFilled[i]) continue;
                if (tank.fill(result, IFluidHandler.FluidAction.SIMULATE) < result.getAmount()) {
                    return false;
                }
                emptyTanksFilled[i] = true;
            }
        }
        if (test) {
            return true;
        }
        for (ItemStack stack : outputItems) {
            stack = stack.m_41777_();
            ItemHandlerHelper.insertItemStacked((IItemHandler)availableItems, (ItemStack)stack, (boolean)false);
        }
        for (FluidStack output : outputFluids) {
            availableFluids.fill(output.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }
}

