/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateSelectionScrollInput;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutConfirmDialog;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.FormattedText;

public class TransferOwnershipWidget<T extends GuiEventListener & Renderable>
extends DLWidgetContainer {
    private static final int GUI_WIDTH = 250;
    private static final int GUI_HEIGHT = 120;
    private static final CreateDynamicWidgets.FooterSize headerSize = CreateDynamicWidgets.FooterSize.DEFAULT;
    private static final CreateDynamicWidgets.FooterSize footerSize = CreateDynamicWidgets.FooterSize.SMALL;
    private final Consumer<GuiEventListener> removeWidgetFunc;
    private final DLScreen parent;
    private final Owner current;
    private final List<Owner> playerList = new ArrayList<Owner>();
    private MultiLineLabel messageLabel;
    private IconSlotWidget icon;
    private ScrollInput selectionBox;
    private int selectedPlayerIndex = 0;

    public TransferOwnershipWidget(DLScreen parent, Owner selected, Consumer<Owner> okAction, Consumer<T> addRenderableWidgetFunc, Consumer<GuiEventListener> removeWidgetFunc) {
        super(parent.width() / 2 - 125, parent.height() / 2 - 60, 250, 120);
        this.parent = parent;
        this.current = selected;
        this.removeWidgetFunc = removeWidgetFunc;
        parent.setAllowedLayer(parent.getAllowedLayer() + 1);
        this.setWidgetLayerIndex(parent.getAllowedLayer());
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ONLINE_PLAYERS, players -> {
            this.playerList.add(new Owner());
            this.playerList.addAll(players.stream().collect(Collectors.toSet()));
            this.selectedPlayerIndex = MathUtils.clamp((int)(this.current == null ? 0 : this.playerList.indexOf(this.current)), (int)0, (int)(this.playerList.size() - 1));
            GuiAreaDefinition workingArea = new GuiAreaDefinition(this.x() + 1, this.y() + headerSize.size(), this.width() - 2, this.height() - headerSize.size() - footerSize.size());
            this.icon = (IconSlotWidget)this.addRenderableOnly((Renderable)new IconSlotWidget(workingArea.getX() + 16, workingArea.getY() + 8, ModGuiIcons.USER.getAsSprite(16, 16)));
            this.selectionBox = (ScrollInput)this.addRenderableWidget((GuiEventListener)new DLCreateSelectionScrollInput(parent, this.icon.x() + this.icon.width() + 6, this.icon.y(), this.width() - (this.icon.x() + this.icon.width()) + this.x() - 16 - 6, 18).setRenderArrow(true).forOptions(this.playerList.stream().map(x -> TextUtils.text((String)x.name())).toList()).setState(this.selectedPlayerIndex).calling(i -> {
                this.selectedPlayerIndex = i;
            }));
            DLCreateIconButton okBtn = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this.x() + this.width() - 17 - 36, this.y() + this.height() - 6 - 18, 18, 18, (ScreenElement)AllIcons.I_CONFIRM));
            okBtn.withCallback(() -> {
                FlyoutConfirmDialog dlg = new FlyoutConfirmDialog(parent, AbstractFlyoutWidget.FlyoutPointer.RIGHT, () -> {
                    DLUtils.doIfNotNull((Object)okAction, x -> x.accept(this.playerList.get(this.selectedPlayerIndex)));
                    this.close();
                }, addRenderableWidgetFunc, w -> removeWidgetFunc.accept((GuiEventListener)w));
                dlg.open(okBtn);
            });
            this.messageLabel = MultiLineLabel.m_94341_((Font)this.font, (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership.warning").m_130940_(ChatFormatting.GOLD), (int)((int)((float)this.selectionBox.m_5711_() / 0.75f)));
        });
        DLCreateIconButton cancelBtn = (DLCreateIconButton)this.addRenderableWidget((GuiEventListener)new DLCreateIconButton(this.x() + this.width() - 7 - 18, this.y() + this.height() - 6 - 18, 18, 18, (ScreenElement)AllIcons.I_MTD_CLOSE));
        cancelBtn.withCallback(() -> this.close());
    }

    public void close() {
        this.parent.setAllowedLayer(this.getWidgetLayerIndex() - 1);
        this.removeWidgetFunc.accept((GuiEventListener)this);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.parent.renderScreenBackground(graphics);
        GuiAreaDefinition workingArea = new GuiAreaDefinition(this.x() + 1, this.y() + headerSize.size(), this.width() - 2, this.height() - headerSize.size() - footerSize.size());
        CreateDynamicWidgets.renderWindow(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ContainerColor.PURPLE, CreateDynamicWidgets.BarColor.GOLD, CreateDynamicWidgets.BarColor.GRAY, headerSize.size(), footerSize.size(), false);
        CreateDynamicWidgets.renderVerticalSeparator(graphics, this.x() + this.width() - 31, this.y() + this.height() - footerSize.size() + 2, footerSize.size() - 4, CreateDynamicWidgets.BarColor.GRAY);
        CreateDynamicWidgets.renderContainer(graphics, workingArea.getX(), workingArea.getY() - 1, workingArea.getWidth(), workingArea.getHeight() + 2, CreateDynamicWidgets.ContainerColor.PURPLE);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.x() + 6), (int)(this.y() + 4), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.transfer_ownership"), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (this.icon != null) {
            ModGuiIcons.WARN.render(graphics, this.icon.x(), this.icon.y() + this.icon.height() + 8);
        }
        if (this.selectionBox != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_((float)this.selectionBox.m_252754_(), (float)(this.selectionBox.m_252907_() + this.selectionBox.m_93694_() + 8), 0.0f);
            graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
            DLUtils.doIfNotNull((Object)this.messageLabel, x -> {
                GuiGraphics guiGraphics = graphics.graphics();
                Objects.requireNonNull(this.font);
                x.m_6508_(guiGraphics, 0, 0, 9, -1);
            });
            graphics.poseStack().m_85849_();
        }
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

