/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class PrimaryStringSelector {
    private final int windowSize;
    private final Queue<String> window;
    private final Map<String, Integer> frequencyMap;
    private String currentPrimary;

    public PrimaryStringSelector(int poolSize) {
        this.windowSize = poolSize;
        this.window = new LinkedList<String>();
        this.frequencyMap = new HashMap<String, Integer>();
        this.currentPrimary = null;
    }

    public void addString(String s) {
        this.window.add(s);
        this.frequencyMap.put(s, this.frequencyMap.getOrDefault(s, 0) + 1);
        if (this.window.size() > this.windowSize) {
            String removed = this.window.poll();
            this.frequencyMap.put(removed, this.frequencyMap.get(removed) - 1);
            if (this.frequencyMap.get(removed) == 0) {
                this.frequencyMap.remove(removed);
            }
        }
        String mostFrequent = null;
        int maxCount = 0;
        for (Map.Entry<String, Integer> entry : this.frequencyMap.entrySet()) {
            if (entry.getValue() <= maxCount) continue;
            maxCount = entry.getValue();
            mostFrequent = entry.getKey();
        }
        if (this.currentPrimary == null) {
            this.currentPrimary = mostFrequent;
        } else {
            int currentCount = this.frequencyMap.getOrDefault(this.currentPrimary, 0);
            int threshold = 1;
            if (!mostFrequent.equals(this.currentPrimary) && maxCount >= currentCount + threshold) {
                this.currentPrimary = mostFrequent;
            }
        }
    }

    public String getCurrentPrimary() {
        return this.currentPrimary;
    }
}

