/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.RocketPath;
import com.rae.creatingspace.api.squedule.RocketSchedule;
import com.rae.creatingspace.api.squedule.ScheduleEntry;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.api.squedule.instruction.ChangeTitleInstruction;
import com.rae.creatingspace.api.squedule.instruction.DestinationInstruction;
import com.rae.creatingspace.api.squedule.instruction.ScheduleInstruction;
import com.rae.creatingspace.content.planets.CSDimensionUtil;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class RocketScheduleRuntime {
    private static final int TBD = -1;
    private static final int INVALID = -2;
    ResourceLocation currentWorld;
    RocketContraptionEntity rocket;
    RocketSchedule schedule;
    public boolean isAutoSchedule;
    public boolean paused;
    public boolean completed;
    public int currentEntry;
    public State state;
    static final int INTERVAL = 40;
    int cooldown;
    List<Integer> conditionProgress;
    List<CompoundTag> conditionContext;
    String currentTitle;
    int ticksInTransit;
    List<Integer> predictionTicks;
    public boolean displayLinkUpdateRequested;

    public RocketScheduleRuntime(RocketContraptionEntity rocket) {
        this.rocket = rocket;
        this.reset();
    }

    public void destinationReached() {
        if (this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.POST_TRANSIT;
        this.conditionProgress.clear();
        this.displayLinkUpdateRequested = true;
        if (this.ticksInTransit > 0) {
            int current = this.predictionTicks.get(this.currentEntry);
            if (current > 0) {
                this.ticksInTransit = (current + this.ticksInTransit) / 2;
            }
            this.predictionTicks.set(this.currentEntry, this.ticksInTransit);
        }
        if (this.currentEntry >= this.schedule.entries.size()) {
            return;
        }
        this.resetConditionProgressAndContext();
    }

    private void resetConditionProgressAndContext() {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        for (int i = 0; i < conditions.size(); ++i) {
            this.conditionProgress.add(0);
            this.conditionContext.add(new CompoundTag());
        }
    }

    public void transitInterrupted() {
        if (this.schedule == null || this.state != State.IN_TRANSIT) {
            return;
        }
        this.state = State.PRE_TRANSIT;
        this.cooldown = 0;
    }

    public void tick(Level level) {
        if (this.currentWorld != this.rocket.m_9236_().m_46472_().m_135782_()) {
            this.currentWorld = this.rocket.m_9236_().m_46472_().m_135782_();
        }
        if (this.schedule == null) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.rocket.isInPropulsionPhase()) {
            ++this.ticksInTransit;
            return;
        }
        if (this.currentEntry >= this.schedule.entries.size() || this.currentEntry < 0) {
            this.currentEntry = 0;
            if (!this.schedule.cyclic) {
                this.paused = true;
                this.completed = true;
            }
            return;
        }
        if (this.state == State.IN_TRANSIT) {
            return;
        }
        if (this.state == State.POST_TRANSIT) {
            this.tickConditions(level);
            return;
        }
        RocketPath nextPath = this.startCurrentInstruction();
        if (nextPath == null) {
            return;
        }
        this.rocket.successfulNavigation();
        if (nextPath.destination == this.rocket.m_9236_().m_46472_().m_135782_() && !this.rocket.isReentry()) {
            this.state = State.IN_TRANSIT;
            this.destinationReached();
            return;
        }
        if (this.rocket.startNavigation(nextPath) != -1) {
            this.state = State.IN_TRANSIT;
        }
    }

    public void tickConditions(Level level) {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        for (int i = 0; i < conditions.size(); ++i) {
            List<ScheduleWaitCondition> list = conditions.get(i);
            if (this.conditionProgress.size() <= i) {
                CreatingSpace.LOGGER.warn("rocket entity of id {} located at {} had an index out of bound for condition", (Object)this.rocket.m_19879_(), (Object)this.rocket.m_20182_());
                this.rocket.disassemble();
                return;
            }
            int progress = this.conditionProgress.get(i);
            if (progress >= list.size()) {
                this.state = State.PRE_TRANSIT;
                ++this.currentEntry;
                return;
            }
            CompoundTag tag = this.conditionContext.get(i);
            ScheduleWaitCondition condition = list.get(progress);
            int prevVersion = tag.m_128451_("StatusVersion");
            if (condition.tickCompletion(level, this.rocket, tag)) {
                this.conditionContext.set(i, new CompoundTag());
                this.conditionProgress.set(i, progress + 1);
                this.displayLinkUpdateRequested |= i == 0;
            }
            this.displayLinkUpdateRequested |= i == 0 && prevVersion != tag.m_128451_("StatusVersion");
        }
    }

    public RocketPath startCurrentInstruction() {
        ScheduleEntry entry = this.schedule.entries.get(this.currentEntry);
        ScheduleInstruction instruction = entry.instruction;
        if (instruction instanceof DestinationInstruction) {
            DestinationInstruction destination = (DestinationInstruction)instruction;
            ResourceLocation destinationWorld = destination.getDestination();
            int cost = CSDimensionUtil.cost(this.currentWorld, destinationWorld);
            if (cost <= 0) {
                return null;
            }
            return new RocketPath(this.currentWorld, destinationWorld, cost);
        }
        if (instruction instanceof ChangeTitleInstruction) {
            ChangeTitleInstruction title = (ChangeTitleInstruction)instruction;
            this.currentTitle = title.getScheduleTitle();
            this.state = State.PRE_TRANSIT;
            ++this.currentEntry;
            return null;
        }
        return null;
    }

    public void setSchedule(RocketSchedule schedule, boolean auto) {
        this.reset();
        this.schedule = schedule;
        this.currentEntry = Mth.m_14045_((int)schedule.savedProgress, (int)0, (int)(schedule.entries.size() - 1));
        this.paused = false;
        this.isAutoSchedule = auto;
        this.predictionTicks = new ArrayList<Integer>();
        schedule.entries.forEach($ -> this.predictionTicks.add(-1));
        this.displayLinkUpdateRequested = true;
    }

    public RocketSchedule getSchedule() {
        return this.schedule;
    }

    public void discardSchedule() {
        this.reset();
    }

    private void reset() {
        this.paused = true;
        this.completed = false;
        this.isAutoSchedule = false;
        this.currentEntry = 0;
        this.currentTitle = "";
        this.schedule = null;
        this.state = State.PRE_TRANSIT;
        this.conditionProgress = new ArrayList<Integer>();
        this.conditionContext = new ArrayList<CompoundTag>();
        this.predictionTicks = new ArrayList<Integer>();
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("CurrentEntry", this.currentEntry);
        tag.m_128379_("AutoSchedule", this.isAutoSchedule);
        tag.m_128379_("Paused", this.paused);
        tag.m_128379_("Completed", this.completed);
        if (this.schedule != null) {
            tag.m_128365_("Schedule", (Tag)this.schedule.write());
        }
        NBTHelper.writeEnum((CompoundTag)tag, (String)"State", (Enum)this.state);
        tag.m_128408_("ConditionProgress", this.conditionProgress);
        tag.m_128365_("ConditionContext", (Tag)NBTHelper.writeCompoundList(this.conditionContext, CompoundTag::m_6426_));
        tag.m_128408_("TransitTimes", this.predictionTicks);
        return tag;
    }

    public void read(CompoundTag tag) {
        this.reset();
        this.paused = tag.m_128471_("Paused");
        this.completed = tag.m_128471_("Completed");
        this.isAutoSchedule = tag.m_128471_("AutoSchedule");
        this.currentEntry = tag.m_128451_("CurrentEntry");
        if (tag.m_128441_("Schedule")) {
            this.schedule = RocketSchedule.fromTag(tag.m_128469_("Schedule"));
        }
        this.state = (State)NBTHelper.readEnum((CompoundTag)tag, (String)"State", State.class);
        for (int i : tag.m_128465_("ConditionProgress")) {
            this.conditionProgress.add(i);
        }
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("ConditionContext", 10), this.conditionContext::add);
        int[] readTransits = tag.m_128465_("TransitTimes");
        if (this.schedule != null) {
            this.schedule.entries.forEach($ -> this.predictionTicks.add(-1));
            if (readTransits.length == this.schedule.entries.size()) {
                for (int i = 0; i < readTransits.length; ++i) {
                    this.predictionTicks.set(i, readTransits[i]);
                }
            }
        }
    }

    public void setSchedulePresentClientside(boolean present) {
        this.schedule = present ? new RocketSchedule() : null;
    }

    public MutableComponent getWaitingStatus(Level level) {
        List<List<ScheduleWaitCondition>> conditions = this.schedule.entries.get((int)this.currentEntry).conditions;
        if (conditions.isEmpty() || this.conditionProgress.isEmpty() || this.conditionContext.isEmpty()) {
            return Component.m_237119_();
        }
        List<ScheduleWaitCondition> list = conditions.get(0);
        int progress = this.conditionProgress.get(0);
        if (progress >= list.size()) {
            return Component.m_237119_();
        }
        CompoundTag tag = this.conditionContext.get(0);
        ScheduleWaitCondition condition = list.get(progress);
        return condition.getWaitingStatus(level, this.rocket, tag);
    }

    public static enum State {
        PRE_TRANSIT,
        IN_TRANSIT,
        POST_TRANSIT;

    }
}

