/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.squedule.condition.CargoThresholdCondition;
import com.rae.creatingspace.content.rocket.RocketContraptionEntity;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack stack = FilterItemStack.empty();

    @Override
    protected Component getUnit() {
        return Component.m_237113_((String)(this.inStacks() ? "\u25a4" : ""));
    }

    @Override
    protected ItemStack getIcon() {
        return this.stack.item();
    }

    @Override
    protected boolean test(Level level, RocketContraptionEntity rocket, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        boolean stacks = this.inStacks();
        int foundItems = 0;
        CombinedInvWrapper items = rocket.getContraption().getStorage().getAllItems();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (!this.stack.test(level, stackInSlot)) continue;
            if (stacks) {
                foundItems += stackInSlot.m_41613_() == stackInSlot.m_41741_() ? 1 : 0;
                continue;
            }
            foundItems += stackInSlot.m_41613_();
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    protected void writeAdditional(CompoundTag tag) {
        super.writeAdditional(tag);
        tag.m_128365_("Item", (Tag)this.stack.serializeNBT());
    }

    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (tag.m_128441_("Item")) {
            this.stack = FilterItemStack.of((CompoundTag)tag.m_128469_("Item"));
        }
    }

    @Override
    public boolean tickCompletion(Level level, RocketContraptionEntity rocket, CompoundTag context) {
        return super.tickCompletion(level, rocket, context);
    }

    public void setItem(int slot, ItemStack stack) {
        this.stack = FilterItemStack.of((ItemStack)stack);
    }

    public ItemStack getItem(int slot) {
        return this.stack.item();
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.condition.threshold.train_holds", (Object[])new Object[]{CreateLang.translateDirect((String)("schedule.condition.threshold." + CreateLang.asId((String)this.getOperator().name())), (Object[])new Object[0])}), (Object)CreateLang.translateDirect((String)"schedule.condition.threshold.x_units_of_item", (Object[])new Object[]{this.getThreshold(), CreateLang.translateDirect((String)("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items")), (Object[])new Object[0]), this.stack.isEmpty() ? CreateLang.translateDirect((String)"schedule.condition.threshold.anything", (Object[])new Object[0]) : (this.stack.isFilterItem() ? CreateLang.translateDirect((String)"schedule.condition.threshold.matching_content", (Object[])new Object[0]) : this.stack.item().m_41786_())}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    private boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    public ResourceLocation getId() {
        return CreatingSpace.resource("item_threshold");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List)ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.condition.threshold.items", (Object[])new Object[0]), (Object)CreateLang.translateDirect((String)"schedule.condition.threshold.stacks", (Object[])new Object[0]))).titled(CreateLang.translateDirect((String)"schedule.condition.threshold.item_measure", (Object[])new Object[0])), "Measure");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, RocketContraptionEntity train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Component.m_237119_();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return CreateLang.translateDirect((String)"schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), CreateLang.translateDirect((String)("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items")), (Object[])new Object[0])});
    }
}

