/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.sealer;

import com.rae.creatingspace.content.life_support.sealer.RoomAtmosphere;
import com.rae.creatingspace.content.life_support.sealer.RoomPressuriserBlock;
import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.EntityInit;
import com.rae.creatingspace.legacy.server.blocks.atmosphere.SealerBlock;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoomPressuriserBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public FluidTank OXYGEN_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            RoomPressuriserBlockEntity.this.notifyUpdate();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_OXYGEN.matches(stack.getFluid());
        }
    };
    public LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public RoomPressuriserBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction localDir;
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == (localDir = (Direction)this.m_58900_().m_61143_((Property)SealerBlock.FACING)).m_122424_()) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tryRoom() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            boolean initialized = false;
            for (RoomAtmosphere room : this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))))) {
                if (room == null) continue;
                initialized = true;
                room.regenerateRoom(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING)));
            }
            if (!initialized) {
                RoomAtmosphere room = new RoomAtmosphere((EntityType)EntityInit.ATMOSPHERE_ENTITY.get(), this.m_58904_());
                room.m_146884_(Vec3.m_82512_((Vec3i)this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))));
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7967_((Entity)room);
                    room.regenerateRoom(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING)));
                }
            }
        }
    }

    public void remove() {
        if (this.f_58857_ != null) {
            for (RoomAtmosphere room : this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))))) {
                if (room == null) continue;
                room.m_6074_();
            }
        }
        super.remove();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void tick() {
        super.tick();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_5776_() && this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_ && this.getSpeed() != 0.0f) {
            List rooms = this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))));
            if (rooms.isEmpty()) {
                this.tryRoom();
            }
            for (RoomAtmosphere room : rooms) {
                if (room == null) continue;
                room.addO2(this.OXYGEN_TANK.drain((int)Math.abs(this.getSpeed()), IFluidHandler.FluidAction.EXECUTE).getAmount() * 10);
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.fluidOptional.cast());
        assert (this.f_58857_ != null);
        List rooms = this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))));
        for (RoomAtmosphere room : rooms) {
            tooltip.add((Component)Component.m_237115_((String)(room.getShape().isClosed() ? "creatingspace.entity.room_atmosphere.sealed" : "creatingspace.entity.room_atmosphere.open")));
            tooltip.add((Component)Component.m_237113_((String)String.format("02 concentration : %.1f mb/m3", Float.valueOf(room.getO2concentration()))));
        }
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        this.OXYGEN_TANK.writeToNBT(compound);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.OXYGEN_TANK.readFromNBT(compound);
    }
}

