/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.sealer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RoomShape {
    ArrayList<AABB> listOfBox;
    boolean closed = true;
    float xRot;
    float yRot;
    float zRot;
    int volume;
    static Codec<List<AABB>> LIST_CODEC = Codec.list((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("minX").forGetter(i -> i.f_82288_), (App)Codec.DOUBLE.fieldOf("minY").forGetter(i -> i.f_82289_), (App)Codec.DOUBLE.fieldOf("minZ").forGetter(i -> i.f_82290_), (App)Codec.DOUBLE.fieldOf("maxX").forGetter(i -> i.f_82291_), (App)Codec.DOUBLE.fieldOf("maxY").forGetter(i -> i.f_82292_), (App)Codec.DOUBLE.fieldOf("maxZ").forGetter(i -> i.f_82293_)).apply((Applicative)instance, AABB::new)));

    RoomShape(List<AABB> listOfBox) {
        this.listOfBox = new ArrayList<AABB>(listOfBox);
        this.calculateVolume();
    }

    RoomShape(List<AABB> listOfBox, int volume) {
        this.listOfBox = new ArrayList<AABB>(listOfBox);
        this.volume = volume;
    }

    RoomShape(List<AABB> listOfBox, int volume, boolean closed) {
        this(listOfBox, volume);
        this.closed = closed;
    }

    public static RoomShape fromNbt(CompoundTag nbt) {
        return new RoomShape((List)((Pair)LIST_CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("listOfBox")).result().orElseThrow()).getFirst(), nbt.m_128451_("volume"), nbt.m_128471_("closed"));
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("listOfBox", (Tag)LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.listOfBox).result().orElse(new CompoundTag()));
        tag.m_128405_("volume", this.volume);
        tag.m_128379_("closed", this.closed);
        return tag;
    }

    public ArrayList<AABB> getListOfBox() {
        return this.listOfBox;
    }

    public void add(BlockPos pos) {
        AABB firstBlock = new AABB(pos);
        this.add(firstBlock);
    }

    public AABB getEncapsulatingBox() {
        Double minX = null;
        Double minY = null;
        Double minZ = null;
        Double maxX = null;
        Double maxY = null;
        Double maxZ = null;
        for (AABB aabb : this.listOfBox) {
            if (minX == null || minX > aabb.f_82288_) {
                minX = aabb.f_82288_;
            }
            if (minY == null || minY > aabb.f_82289_) {
                minY = aabb.f_82289_;
            }
            if (minZ == null || minZ > aabb.f_82290_) {
                minZ = aabb.f_82290_;
            }
            if (maxX == null || maxX < aabb.f_82291_) {
                maxX = aabb.f_82291_;
            }
            if (maxY == null || maxY < aabb.f_82292_) {
                maxY = aabb.f_82292_;
            }
            if (maxZ != null && !(maxZ < aabb.f_82293_)) continue;
            maxZ = aabb.f_82293_;
        }
        if (this.listOfBox.isEmpty()) {
            return null;
        }
        return new AABB(minX.doubleValue(), minY.doubleValue(), minZ.doubleValue(), maxX.doubleValue(), maxY.doubleValue(), maxZ.doubleValue());
    }

    public void addAll(List<BlockPos> posList) {
        for (BlockPos pos : posList) {
            this.add(pos);
        }
    }

    private void add(AABB aabb) {
        this.add(List.of(aabb));
    }

    private void add(List<AABB> aabbs) {
        this.listOfBox.addAll(aabbs);
        for (AABB aabb : aabbs) {
            this.volume += (int)this.getVolume(aabb);
        }
    }

    public List<Entity> getEntitiesInside(Level level) {
        ArrayList entities = new ArrayList();
        for (AABB box : this.listOfBox) {
            entities.addAll(level.m_45933_(null, box));
        }
        return entities.stream().distinct().toList();
    }

    public void calculateVolume() {
        double volume = 0.0;
        for (AABB aabb : this.listOfBox) {
            volume += this.getVolume(aabb);
        }
        this.volume = (int)volume;
    }

    public double getVolume(AABB aabb) {
        return aabb.m_82362_() * aabb.m_82376_() * aabb.m_82385_();
    }

    public double getVolume() {
        return this.volume;
    }

    public boolean inside(AABB colBox) {
        for (AABB box : this.listOfBox) {
            if (!box.m_82381_(colBox)) continue;
            return true;
        }
        return false;
    }

    public void remove(BlockPos pos) {
        this.listOfBox.removeIf(aabb -> aabb.m_82390_(Vec3.m_82512_((Vec3i)pos)));
    }

    public void remove(AABB toRemove) {
        ArrayList<AABB> toRemoveList = new ArrayList<AABB>();
        for (AABB aabb : this.listOfBox) {
            toRemoveList.addAll(this.carve(toRemove, aabb));
        }
        this.listOfBox = toRemoveList;
    }

    public void setClosed() {
        this.closed = true;
    }

    public void setOpen() {
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private List<AABB> carve(AABB carver, AABB carved) {
        if (carved.m_82381_(carver)) {
            return List.of(carved);
        }
        AABB iCarver = carver.m_82323_(carved);
        ArrayList<AABB> aabbs = new ArrayList<AABB>(6);
        aabbs.add(new AABB(carved.f_82288_, carved.f_82289_, carved.f_82290_, iCarver.f_82288_, carved.f_82292_, carved.f_82293_));
        aabbs.add(new AABB(iCarver.f_82291_, carved.f_82289_, carved.f_82290_, carver.f_82291_, carved.f_82292_, carved.f_82293_));
        aabbs.add(new AABB(iCarver.f_82288_, carved.f_82289_, carved.f_82290_, iCarver.f_82291_, carved.f_82292_, iCarver.f_82290_));
        aabbs.add(new AABB(iCarver.f_82288_, carved.f_82289_, iCarver.f_82293_, iCarver.f_82291_, carved.f_82292_, carved.f_82293_));
        aabbs.add(new AABB(iCarver.f_82288_, carved.f_82289_, iCarver.f_82290_, iCarver.f_82291_, iCarver.f_82289_, iCarver.f_82293_));
        aabbs.add(new AABB(iCarver.f_82288_, iCarver.f_82292_, iCarver.f_82290_, iCarver.f_82291_, carved.f_82292_, iCarver.f_82293_));
        return aabbs.stream().filter(aabb -> aabb.m_82309_() != 0.0).toList();
    }
}

