/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.content.life_support.spacesuit;

import com.rae.creatingspace.content.life_support.spacesuit.OxygenBacktankItem;
import com.rae.creatingspace.content.life_support.spacesuit.OxygenBacktankUtil;
import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.init.ingameobject.ItemInit;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OxygenBacktankBlockEntity
extends SmartBlockEntity
implements Nameable {
    public int oxygenLevel;
    public int oxygenLevelTimer;
    private int prevOxygenLevel;
    private final Component defaultName;
    private Component customName;
    private int capacityEnchantLevel;
    private ListTag enchantmentTag;
    private final FluidTank OXYGEN_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_OXYGEN.matches(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    };
    public LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.DOWN) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public OxygenBacktankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.defaultName = OxygenBacktankBlockEntity.getDefaultName();
        this.enchantmentTag = new ListTag();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static Component getDefaultName() {
        return ((OxygenBacktankItem.Layered)((Object)ItemInit.COPPER_OXYGEN_BACKTANK.get())).m_41466_();
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_()) {
            this.prevOxygenLevel = this.oxygenLevel;
            this.oxygenLevel = this.OXYGEN_TANK.getFluidAmount();
            this.m_6596_();
            this.sendData();
        }
        BlockState state = this.m_58900_();
        int prevComparatorLevel = this.getComparatorOutput();
        if (this.getComparatorOutput() != prevComparatorLevel && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46717_(this.f_58858_, state.m_60734_());
        }
        if (this.OXYGEN_TANK.getSpace() == 0) {
            this.sendData();
        }
    }

    public int getComparatorOutput() {
        int max = OxygenBacktankUtil.maxOxygen(this.capacityEnchantLevel);
        return ComparatorUtil.fractionToRedstoneLevel((double)((float)this.oxygenLevel / (float)max));
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Oxygen", this.oxygenLevel);
        compound.m_128405_("prevOxygen", this.prevOxygenLevel);
        compound.m_128405_("Timer", this.oxygenLevelTimer);
        compound.m_128405_("CapacityEnchantment", this.capacityEnchantLevel);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128365_("Enchantments", (Tag)this.enchantmentTag);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        int prev = this.oxygenLevel;
        this.capacityEnchantLevel = compound.m_128451_("CapacityEnchantment");
        this.OXYGEN_TANK.setCapacity(OxygenBacktankUtil.maxOxygen(this.capacityEnchantLevel));
        this.oxygenLevel = compound.m_128451_("Oxygen");
        this.prevOxygenLevel = compound.m_128451_("prevOxygen");
        this.oxygenLevelTimer = compound.m_128451_("Timer");
        this.enchantmentTag = compound.m_128437_("Enchantments", 10);
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        if (prev != 0 && prev != this.oxygenLevel && this.oxygenLevel == OxygenBacktankUtil.maxOxygen(this.capacityEnchantLevel) && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.4f, 1.0f, true);
        Vec3 baseMotion = new Vec3(0.25, 0.1, 0.0);
        Vec3 baseVec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        for (int i = 0; i < 360; i += 10) {
            Vec3 m = VecHelper.rotate((Vec3)baseMotion, (double)i, (Direction.Axis)Direction.Axis.Y);
            Vec3 v = baseVec.m_82549_(m.m_82541_().m_82490_(0.25));
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123764_, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
        }
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public int getOxygenLevel() {
        return this.oxygenLevel;
    }

    public void setOxygenLevel(int oxygenLevel) {
        this.oxygenLevel = oxygenLevel;
        this.OXYGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_OXYGEN.get(), oxygenLevel));
        this.m_6596_();
        this.sendData();
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_7770_() {
        return this.customName;
    }

    public ListTag getEnchantmentTag() {
        return this.enchantmentTag;
    }

    public void setEnchantmentTag(ListTag enchantmentTag) {
        this.enchantmentTag = enchantmentTag;
    }

    public void setCapacityEnchantLevel(int capacityEnchantLevel) {
        this.capacityEnchantLevel = capacityEnchantLevel;
        this.OXYGEN_TANK.setCapacity(OxygenBacktankUtil.maxOxygen(capacityEnchantLevel));
    }
}

